% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.assoc.R
\name{plot.assoc}
\alias{plot.assoc}
\title{plot.assoc}
\usage{
\method{plot}{assoc}(x, reorder = TRUE, gray = FALSE, grey = FALSE,
  ...)
}
\arguments{
\item{x}{matrix: association within [0,+1]}

\item{reorder}{logical: if the rows (variables) of the loading matrix should be reordered (default: \code{TRUE})}

\item{gray}{logical: should be a gray scale color palette used or not (default: \code{FALSE})}

\item{grey}{logical: should be a gray scale color palette used or not (default: \code{FALSE})}

\item{...}{further parameter given to the \code{\link{plot.matrix}} command}
}
\value{
a plot
}
\description{
Visualizes a association matrix with a colored or gray heatmap. As a rule of thumb the breaks are determined 
by the \href{https://en.wikipedia.org/wiki/Effect_size#Pearson_r_or_correlation_coefficient}{effect sizes} given by 
Cohen (\code{c(-1, -0.4, -0.2, -0.05, 0, +0.05, +0.2, +0.4, +1)}. 
You may need to modify \code{mar} with the \code{\link[graphics]{par}} command from its default 
\code{c(5.1,4.1,4.1,2.1)}.
See
\itemize{
\item \code{vignette('plot.matrix')} for detailed examples, and
\item \code{\link{plot.matrix}} for further parameters.
}
}
\details{
If either the parameter \code{grey} or \code{gray} is \code{TRUE} then a gray color palette is used.
}
\examples{
par(mar=c(5.1, 4.1, 4.1, 4.1))
# association matrix
data(Titanic.cramer)
plot(as.assoc(Titanic.cramer))
plot(as.assoc(Titanic.cramer), gray=TRUE)
plot(as.assoc(Titanic.cramer[,1:3]), reorder=FALSE)
}
