% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_weights.R
\name{case_weights}
\alias{case_weights}
\title{Using case weights with parsnip}
\description{
Case weights are positive numeric values that influence how much each data
point has during the model fitting process. There are a variety of situations
where case weights can be used.
}
\details{
tidymodels packages differentiate \emph{how} different types of case weights
should be used during the entire data analysis process, including
preprocessing data, model fitting, performance calculations, etc.

The tidymodels packages require users to convert their numeric vectors to a
vector class that reflects how these should be used. For example, there are
some situations where the weights should not affect operations such as
centering and scaling or other preprocessing operations.

The types of weights allowed in tidymodels are:
\itemize{
\item Frequency weights via \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}
\item Importance weights via \code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}
}

More types can be added by request.

For parsnip, the \code{\link[=fit]{fit()}} and \code{\link[=fit_xy]{fit_xy()}} functions contain a \code{case_weight}
argument that takes these data. For Spark models, the argument value should
be a character value.
}
\seealso{
\code{\link[=frequency_weights]{frequency_weights()}}, \code{\link[=importance_weights]{importance_weights()}}, \code{\link[=fit]{fit()}}, \code{\link[=fit_xy]{fit_xy()}}
}
