# compare_parameters, proper printing for CI=NULL #820

    Code
      compare_parameters(m1, m2, ci = NULL)
    Output
      Parameter    |    m1 |    m2
      ----------------------------
      (Intercept)  | 30.10 | 30.10
      hp           | -0.07 | -0.07
      ----------------------------
      Observations |    32 |    32

# compare_parameters, correct random effects

    Code
      cp
    Output
      # Fixed Effects
      
      Parameter   |                   m0 |                   m1 |                   m2
      --------------------------------------------------------------------------------
      (Intercept) |  0.91 ( 0.75,  1.07) |  0.68 (-0.54,  1.91) |  1.41 ( 1.06,  1.75)
      child       | -1.23 (-1.39, -1.08) | -1.67 (-1.84, -1.51) | -0.53 (-0.77, -0.29)
      camper [1]  |  1.05 ( 0.88,  1.23) |  0.94 ( 0.77,  1.12) |  0.58 ( 0.39,  0.78)
      zg          |                      |                      |  0.13 ( 0.05,  0.21)
      
      # Fixed Effects (Zero-Inflation Component)
      
      Parameter   | m0 | m1 |                   m2
      --------------------------------------------
      (Intercept) |    |    | -0.92 (-2.07,  0.22)
      child       |    |    |  1.96 ( 1.38,  2.54)
      
      # Random Effects
      
      Parameter               | m0 |                   m1 |                   m2
      --------------------------------------------------------------------------
      SD (Intercept: ID)      |    |  0.27 ( 0.11,  0.63) |  0.28 ( 0.13,  0.60)
      SD (Intercept: persons) |    |  1.21 ( 0.60,  2.43) |                     
      
      # Random Effects (Zero-Inflation Component)
      
      Parameter               | m0 | m1 |                   m2
      --------------------------------------------------------
      SD (Intercept: persons) |    |    |  1.08 ( 0.49,  2.37)

# compare_parameters, print_md

    Code
      print(out)
    Output
      +----------------+-----------------------+--------+----------------------+--------+
      |                | lm1                            | lm2                           |
      +----------------+-----------------------+--------+----------------------+--------+
      | Parameter      | Estimate (ci)         | p      | Estimate (ci)        | p      |
      +================+=======================+========+======================+========+
      | *Groups*                                                                        |
      +----------------+-----------------------+--------+----------------------+--------+
      | grp (2)        | -4.31 (-15.95, 7.32)  | 0.465  | 0.32 (-22.56, 23.20) | 0.978  |
      +----------------+-----------------------+--------+----------------------+--------+
      | grp (3)        | -1.31 (-13.47, 10.84) | 0.831  | 3.77 (-19.72, 27.26) | 0.752  |
      +----------------+-----------------------+--------+----------------------+--------+
      | *Interactions*                                                                  |
      +----------------+-----------------------+--------+----------------------+--------+
      | Days * grp (2) |                       |        | -1.01 (-5.35, 3.32)  | 0.645  |
      +----------------+-----------------------+--------+----------------------+--------+
      | Days * grp (3) |                       |        | -1.11 (-5.53, 3.31)  | 0.621  |
      +----------------+-----------------------+--------+----------------------+--------+
      | *Controls*                                                                      |
      +----------------+-----------------------+--------+----------------------+--------+
      | Days           | 10.44 (8.84, 12.03)   | <0.001 | 11.23 (7.87, 14.60)  | <0.001 |
      +----------------+-----------------------+--------+----------------------+--------+
      |                |                       |        |                      |        |
      +----------------+-----------------------+--------+----------------------+--------+
      | Observations   | 180                   |        | 180                  |        |
      +----------------+-----------------------+--------+----------------------+--------+ 

---

    Code
      print_md(cp)
    Output
      +-------------------------+-----------------------+--------+----------------------+--------+
      |                         | lm1                            | lm2                           |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | Parameter               | Estimate (ci)         | p      | Estimate (ci)        | p      |
      +=========================+=======================+========+======================+========+
      | Fixed Effects                                                                            |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | Days                    | 10.44 (8.84, 12.03)   | <0.001 | 11.23 (7.87, 14.60)  | <0.001 |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | grp [2]                 | -4.31 (-15.95, 7.32)  | 0.465  | 0.32 (-22.56, 23.20) | 0.978  |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | grp [3]                 | -1.31 (-13.47, 10.84) | 0.831  | 3.77 (-19.72, 27.26) | 0.752  |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | Days * grp [2]          |                       |        | -1.01 (-5.35, 3.32)  | 0.645  |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | Days * grp [3]          |                       |        | -1.11 (-5.53, 3.31)  | 0.621  |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | Random Effects                                                                           |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | SD (Intercept: Subject) | 37.06 (25.85, 53.13)  |        | 37.08 (25.85, 53.19) |        |
      +-------------------------+-----------------------+--------+----------------------+--------+
      | SD (Residual)           | 31.13 (27.89, 34.75)  |        | 31.30 (28.02, 34.96) |        |
      +-------------------------+-----------------------+--------+----------------------+--------+ 

---

    Code
      print(out)
    Output
      +----------------+-----------------------+--------+----------------------+--------+
      |                | lm1                            | lm2                           |
      +----------------+-----------------------+--------+----------------------+--------+
      | Parameter      | Estimate (ci)         | p      | Estimate (ci)        | p      |
      +================+=======================+========+======================+========+
      | *Groups*                                                                        |
      +----------------+-----------------------+--------+----------------------+--------+
      | grp (1)        | 0.00                  |        | 0.00                 |        |
      +----------------+-----------------------+--------+----------------------+--------+
      | grp (2)        | -4.31 (-15.95, 7.32)  | 0.465  | 0.32 (-22.56, 23.20) | 0.978  |
      +----------------+-----------------------+--------+----------------------+--------+
      | grp (3)        | -1.31 (-13.47, 10.84) | 0.831  | 3.77 (-19.72, 27.26) | 0.752  |
      +----------------+-----------------------+--------+----------------------+--------+
      | *Interactions*                                                                  |
      +----------------+-----------------------+--------+----------------------+--------+
      | Days * grp (2) |                       |        | -1.01 (-5.35, 3.32)  | 0.645  |
      +----------------+-----------------------+--------+----------------------+--------+
      | Days * grp (3) |                       |        | -1.11 (-5.53, 3.31)  | 0.621  |
      +----------------+-----------------------+--------+----------------------+--------+
      | *Controls*                                                                      |
      +----------------+-----------------------+--------+----------------------+--------+
      | Days           | 10.44 (8.84, 12.03)   | <0.001 | 11.23 (7.87, 14.60)  | <0.001 |
      +----------------+-----------------------+--------+----------------------+--------+
      |                |                       |        |                      |        |
      +----------------+-----------------------+--------+----------------------+--------+
      | Observations   | 180                   |        | 180                  |        |
      +----------------+-----------------------+--------+----------------------+--------+ 

---

    Code
      print(out)
    Output
      +----------------+-----------------------+----------------------+
      | Parameter      | lm1                   | lm2                  |
      +================+=======================+======================+
      | *Groups*                                                      |
      +----------------+-----------------------+----------------------+
      | grp (1)        | 0.00                  | 0.00                 |
      +----------------+-----------------------+----------------------+
      | grp (2)        | -4.31 (-15.95, 7.32)  | 0.32 (-22.56, 23.20) |
      +----------------+-----------------------+----------------------+
      | grp (3)        | -1.31 (-13.47, 10.84) | 3.77 (-19.72, 27.26) |
      +----------------+-----------------------+----------------------+
      | *Interactions*                                                |
      +----------------+-----------------------+----------------------+
      | Days * grp (2) |                       | -1.01 (-5.35, 3.32)  |
      +----------------+-----------------------+----------------------+
      | Days * grp (3) |                       | -1.11 (-5.53, 3.31)  |
      +----------------+-----------------------+----------------------+
      | *Controls*                                                    |
      +----------------+-----------------------+----------------------+
      | Days           | 10.44 (8.84, 12.03)   | 11.23 (7.87, 14.60)  |
      +----------------+-----------------------+----------------------+
      |                |                       |                      |
      +----------------+-----------------------+----------------------+
      | Observations   | 180                   | 180                  |
      +----------------+-----------------------+----------------------+ 

