% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.assign.r
\name{opal.assign.table}
\alias{opal.assign.table}
\title{Data assignment to a data.frame}
\usage{
opal.assign.table(opal, symbol, value, variables = NULL,
  missings = FALSE, identifiers = NULL, id.name = NULL,
  updated.name = NULL, class = "data.frame", async = FALSE)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{symbol}{Name of the R symbol.}

\item{value}{The value to assign evaluated in the following order: a fully qualified name of a variable or a table in Opal.}

\item{variables}{List of variable names or Javascript expression that selects the variables of a table (ignored if value does not refere to a table). See javascript documentation: http://wiki.obiba.org/display/OPALDOC/Variable+Methods}

\item{missings}{If TRUE, missing values will be pushed from Opal to R, default is FALSE.}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to R (from Opal 2.0).}

\item{id.name}{Add a vector with the given name representing the entity identifiers (from Opal 2.6). Default is NULL.}

\item{updated.name}{Add a vector with the given name representing the creation and last update timestamps (from Opal 2.6). Default is NULL.}

\item{class}{The data frame class into which the table is written: can 'data.frame' (default and fallback) or 'tibble' (from Opal 2.6).}

\item{async}{R script is executed asynchronously within the session (default is FALSE). If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Assign a Opal table to a data.frame identified by a R symbol in the current R session.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# assign a list of variables from table CNSIM1
opal.assign.table(o, symbol="D", value="datashield.CNSIM1", variables=list("GENDER","LAB_TSC"))
opal.execute(o, "colnames(D)")
# assign a table CNSIM1 with a identifiers column
opal.assign.table(o, symbol="H", value="datashield.CNSIM1", id.name="id")
opal.execute(o, "colnames(H)")
# assign all the variables matching 'LAB' from table HOP of opal object o
opal.assign.table(o, symbol="D", value="datashield.CNSIM1", variables="name().matches('LAB_')")
opal.execute(o, "colnames(D)")
opal.logout(o)
}
}
\seealso{
Other assignment functions: \code{\link{opal.assign.data}},
  \code{\link{opal.assign.script}},
  \code{\link{opal.assign.table.tibble}},
  \code{\link{opal.assign}}
}
\concept{assignment functions}
