% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertEmax.R
\name{convertEmaxHill}
\alias{convertEmaxHill}
\title{Convert linear effect to Emax-Hill effect}
\usage{
convertEmaxHill(
  ui,
  emax = "Emax",
  ec50 = "EC50",
  g = "g",
  imax = "Imax",
  ic50 = "IC50",
  ek = c("Ik", "Ek"),
  cc = c("Ec", "Cc")
)
}
\arguments{
\item{ui}{rxode2 model}

\item{emax}{Emax parameter}

\item{ec50}{EC50 parameter}

\item{g}{hill coefficient}

\item{imax}{Imax parameter used when input model contains "Ik"
instead of "Ek"}

\item{ic50}{IC50 parameter used when input model contains "Ik"
instead of "Ek"}

\item{ek}{simulation linear constant}

\item{cc}{the concentration value}
}
\value{
Model with the linear effect converted to an Emax effect
}
\description{
Convert linear effect to Emax-Hill effect
}
\examples{

readModelDb("PK_2cmt_no_depot") |>
  addIndirectLin(stim="in") |>
  convertEmaxHill()

# can also specify as emax=1

readModelDb("PK_2cmt_no_depot") |>
  addIndirectLin(stim="in") |>
  convertEmaxHill(emax=1)

}
\author{
Matthew L. Fidler
}
