% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackByTable.R
\name{stackByTable}
\alias{stackByTable}
\title{Join data files in a zipped NEON data package by table type}
\usage{
stackByTable(
  filepath,
  savepath = NA,
  folder = FALSE,
  saveUnzippedFiles = FALSE,
  dpID = NA,
  package = NA,
  nCores = 1,
  useFasttime = FALSE
)
}
\arguments{
\item{filepath}{The location of the zip file}

\item{savepath}{The location to save the output files to}

\item{folder}{T or F: does the filepath point to a parent, unzipped folder, or a zip file? If F, assumes the filepath points to a zip file. Defaults to F. No longer needed; included for back compatibility.}

\item{saveUnzippedFiles}{T or F: should the unzipped monthly data folders be retained?}

\item{dpID}{Data product ID of product to stack. Ignored and determined from data unless input is a vector of files, generally via stackFromStore().}

\item{package}{Data download package, either basic or expanded. Ignored and determined from data unless input is a vector of files, generally via stackFromStore().}

\item{nCores}{The number of cores to parallelize the stacking procedure. To automatically use the maximum number of cores on your machine we suggest setting nCores=parallel::detectCores(). By default it is set to a single core.}

\item{useFasttime}{Should the fasttime package be used to read date-time variables? Only relevant if savepath="envt". Defaults to false.}
}
\value{
All files are unzipped and one file for each table type is created and written. If savepath="envt" is specified, output is a named list of tables; otherwise, function output is null and files are saved to the location specified.
}
\description{
Given a zipped data file, do a full join of all data files, grouped by table type.
This should result in a small number of large files.
}
\examples{
\dontrun{
# To unzip and merge files downloaded from the NEON Data Portal
stackByTable("~/NEON_par.zip")

# To unzip and merge files downloaded using zipsByProduct()
stackByTable("~/filesToStack00024")
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Christine Laney \email{claney@battelleecology.org}
Claire Lunch \email{clunch@battelleecology.org}
}
