% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_reverse_hourglass_test.R
\name{stat_reverse_hourglass_test}
\alias{stat_reverse_hourglass_test}
\title{Reverse Hourglass Test}
\usage{
stat_reverse_hourglass_test(phyex_set, modules, ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{modules}{A named list with elements 'early', 'mid', and 'late' containing
stage indices for each developmental module}

\item{...}{Additional arguments passed to stat_generic_conservation_test}
}
\value{
A ConservationTestResult object with reverse hourglass test results
}
\description{
Test for reverse hourglass patterns in transcriptomic data by comparing
mid developmental stages to early and late developmental stages.
}
\details{
The reverse hourglass test evaluates whether mid developmental stages show
higher transcriptomic index values (indicating younger genes) compared to both
early and late stages. This creates a reverse hourglass pattern where recently
evolved genes dominate during mid-development. The test computes a score based
on the minimum difference between mid vs. early and mid vs. late TXI values.
}
\examples{
# Define developmental modules
modules <- list(early = 1:2, mid = 3:5, late = 6:7)
result <- stat_reverse_hourglass_test(example_phyex_set_old, modules=modules)

}
\seealso{
\code{\link{stat_generic_conservation_test}}, \code{\link{stat_reductive_hourglass_test}}
}
