% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion.R
\name{distribution_dp}
\alias{distribution_dp}
\title{Distribution plot of a view object}
\usage{
distribution_dp(obj, maxpts = 50000, alpha = 0.1, ...)
}
\arguments{
\item{obj}{\code{View} object.}

\item{maxpts}{maximum number of points to plot.}

\item{alpha}{ggplot aesthetic value.}

\item{...}{passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}},}
}
\value{
a \code{ggplot} object.
}
\description{
Distribution plot of a view object
}
\examples{
r1 <- get_sample_recording()
rv1 <- get_raw_view(r1, "Central", "", "Sitar")
pv1 <- get_processed_view(rv1)
dp <- c("LWrist", "RWrist", "LElbow", "RElbow", "LEye", "REye", "Neck", "MidHip")
fv1 <- apply_filter_sgolay(pv1, data_point = dp, n = 41, p = 4)
distribution_dp(fv1)
}
