% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepData.R
\name{prepData}
\alias{prepData}
\title{Preprocessing of the tracking data}
\usage{
prepData(
  trackData,
  type = c("LL", "UTM"),
  coordNames = c("x", "y"),
  LLangle = NULL
)
}
\arguments{
\item{trackData}{A dataframe of the tracking data, including at least coordinates
(either longitude/latitude values or cartesian coordinates), and optionnaly a field \code{ID}
(identifiers for the observed individuals). Additionnal fields are considered as covariates.
Note that, if the names of the coordinates are not "x" and "y", the \code{coordNames} argument
should specified. Tracking data should be structured so that the rows for each track (or each animal)
are grouped together, and ordered by date, in the data frame.}

\item{type}{\code{'LL'} if longitude/latitude provided (default), \code{'UTM'} if easting/northing.}

\item{coordNames}{Names of the columns of coordinates in the data frame. Default: \code{c("x","y")}.}

\item{LLangle}{Logical. If TRUE, the turning angle is calculated with \code{geosphere::bearing}
(default), else calculated with \code{atan2}.}
}
\value{
An object \code{moveData}, i.e. a dataframe of:
\item{ID}{The ID(s) of the observed animal(s)}
\item{step}{The step lengths - in kilometers if longitude/latitude provided, and in the metrics of
the data otherwise}
\item{angle}{The turning angles (if any) - in radians}
\item{x}{Either Easting or longitude (or e.g. depth for 1D data)}
\item{y}{Either Northing or latitude (all zero if 1D data)}
\item{...}{Covariates (if any)}
}
\description{
Preprocessing of the tracking data
}
\examples{
coord1 <- c(1,2,3,4,5,6,7,8,9,10)
coord2 <- c(1,1,1,2,2,2,1,1,1,2)
trackData <- data.frame(coord1=coord1,coord2=coord2)
d <- prepData(trackData,type='UTM',coordNames=c("coord1","coord2"))

}
