% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictTPM.R
\name{predictTPM}
\alias{predictTPM}
\title{Predict transition probabilities for new covariate values}
\usage{
predictTPM(m, newData, beta = m$mle$beta, returnCI = FALSE, alpha = 0.95)
}
\arguments{
\item{m}{Fitted moveHMM object, as returned by \code{\link{fitHMM}}}

\item{newData}{Data frame with columns for the covariates}

\item{beta}{Optional matrix of regression coefficients for the transition
probability model. By default, uses estimates in \code{m}.}

\item{returnCI}{Logical indicating whether confidence intervals should
be returned. Default: FALSE.}

\item{alpha}{Confidence level if returnCI = TRUE. Default: 0.95, i.e.,
95\% confidence intervals.}
}
\value{
List with elements 'mle', 'lci', and 'uci' (the last two only if
returnCI = TRUE). Each element is an array, where each layer is a
transition probability matrix corresponding to a row of newData.
}
\description{
Predict transition probabilities for new covariate values
}
