% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonoClust.R
\name{find_split}
\alias{find_split}
\title{Find the Best Split}
\usage{
find_split(
  data,
  cuts,
  frame_row,
  cloc,
  dist,
  variables,
  minsplit,
  minbucket,
  ncores
)
}
\arguments{
\item{data}{Original data set.}

\item{cuts}{Cuts data set, which has the next higher value of each variable
in the original data set.}

\item{frame_row}{One row of the split tree as data frame.}

\item{cloc}{Vector of current cluster membership.}

\item{dist}{Distance matrix of all observations in the data.
exported function yet. Vector of 1 for all observations.}

\item{variables}{List of variables selected for clustering procedure. It
could be a vector of variable indexes, or a vector of variable names.}

\item{minsplit}{The minimum number of observations that must exist in a node
in order for a split to be attempted.}

\item{minbucket}{The minimum number of observations in any terminal leaf
node. Default is \code{minsplit/3}.}

\item{ncores}{Number of CPU cores on the current host.}
}
\value{
This function changes the frame in global environment, it's
not supposed to return anything.
}
\description{
Find the best split in terms of reduction in inertia for the transferred
node, indicate by row. We are keeping all of the information regarding which
clusters we have in. At this point, we want to find the terminal node with
the greatest change in inertia and bi-partition it. The way this is done is
incredibly inefficient. We check every single possible split. This should be
done much better since there is a single local maximum with respect to
inertia so we should use this property to not do an exhaustive check, but to
check the center the 25\% and 75\% and then search more selectively from there.
This is a fairly simple discrete optimization problem and could reduce
computation time .
}
\keyword{internal}
