% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDescriptor.R
\name{ModelDescriptor}
\alias{ModelDescriptor}
\title{Represent a Model with Meta-Info}
\usage{
ModelDescriptor(
  graph,
  ingress,
  task,
  optimizer = NULL,
  loss = NULL,
  callbacks = NULL,
  pointer = NULL,
  pointer_shape = NULL
)
}
\arguments{
\item{graph}{(\code{\link[mlr3pipelines:Graph]{Graph}})\cr
\code{Graph} of \code{\link{PipeOpModule}} and \code{\link[mlr3pipelines:mlr_pipeops_nop]{PipeOpNOP}} operators.}

\item{ingress}{(uniquely named \code{list} of \code{TorchIngressToken})\cr
List of inputs that go into \code{graph}. Names of this must be a subset of \code{graph$input$name}.}

\item{task}{(\code{\link[mlr3:Task]{Task}})\cr
(Training)-Task for which the model is being built. May be necessary for for some aspects of what loss to use etc.}

\item{optimizer}{(\code{\link{TorchOptimizer}} | \code{NULL})\cr
Additional info: what optimizer to use.}

\item{loss}{(\code{\link{TorchLoss}} | \code{NULL})\cr
Additional info: what loss to use.}

\item{callbacks}{(A \code{list} of \code{\link{CallbackSet}} or \code{NULL})\cr
Additional info: what callbacks to use.}

\item{pointer}{(\code{character(2)} | \code{NULL})\cr
Indicating an element on which a model is. Points to an output channel within \code{graph}:
Element 1 is the \code{PipeOp}'s id and element 2 is that \code{PipeOp}'s output channel.}

\item{pointer_shape}{(\code{integer} | \code{NULL})\cr
Shape of the output indicated by \code{pointer}.}
}
\value{
(\code{ModelDescriptor})
}
\description{
Represents a \emph{model}; possibly a complete model, possibly one in the process of being built up.

This model takes input tensors of shapes \code{shapes_in} and
pipes them through \code{graph}. Input shapes get mapped to input channels of \code{graph}.
Output shapes are named by the output channels of \code{graph}; it is also possible
to represent no-ops on tensors, in which case names of input and output should be identical.

\code{ModelDescriptor} objects typically represent partial models being built up, in which case the \code{pointer} slot
indicates a specific point in the graph that produces a tensor of shape \code{pointer_shape}, on which the graph should
be extended.
It is allowed for the \code{graph} in this structure to be modified by-reference in different parts of the code.
However, these modifications may never add edges with elements of the \code{Graph} as destination. In particular, no
element of \code{graph$input} may be removed by reference, e.g. by adding an edge to the \code{Graph} that has the input
channel of a \code{PipeOp} that was previously without parent as its destination.

In most cases it is better to create a specific \code{ModelDescriptor} by training a \code{\link[mlr3pipelines:Graph]{Graph}} consisting (mostly) of
operators \code{\link{PipeOpTorchIngress}}, \code{\link{PipeOpTorch}}, \code{\link{PipeOpTorchLoss}}, \code{\link{PipeOpTorchOptimizer}}, and
\code{\link{PipeOpTorchCallbacks}}.

A \code{ModelDescriptor} can be converted to a \code{\link{nn_graph}} via \code{\link{model_descriptor_to_module}}.
}
\seealso{
Other Model Configuration: 
\code{\link{mlr_pipeops_torch_callbacks}},
\code{\link{mlr_pipeops_torch_loss}},
\code{\link{mlr_pipeops_torch_optimizer}},
\code{\link{model_descriptor_union}()}

Other Graph Network: 
\code{\link{TorchIngressToken}()},
\code{\link{mlr_learners_torch_model}},
\code{\link{mlr_pipeops_module}},
\code{\link{mlr_pipeops_torch}},
\code{\link{mlr_pipeops_torch_ingress}},
\code{\link{mlr_pipeops_torch_ingress_categ}},
\code{\link{mlr_pipeops_torch_ingress_ltnsr}},
\code{\link{mlr_pipeops_torch_ingress_num}},
\code{\link{model_descriptor_to_learner}()},
\code{\link{model_descriptor_to_module}()},
\code{\link{model_descriptor_union}()},
\code{\link{nn_graph}()}
}
\concept{Graph Network}
\concept{Model Configuration}
