% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpNMF.R
\name{mlr_pipeops_nmf}
\alias{mlr_pipeops_nmf}
\alias{PipeOpNMF}
\title{Non-negative Matrix Factorization}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Extracts non-negative components from data by performing non-negative matrix factorization. Only
affects non-negative numerical features. See \code{\link[NMF:nmf]{nmf()}} for details.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpNMF$new(id = "nmf", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"nmf"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise
be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}.

The output is the input \code{\link[mlr3:Task]{Task}} with all affected numeric features replaced by their
non-negative components.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpTaskPreproc}},
as well as the elements of the object returned by \code{\link[NMF:nmf]{nmf()}}.
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{rank} :: \code{integer(1)}\cr
Factorization rank, i.e., number of components. Initialized to \code{2}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{method} :: \code{character(1)}\cr
Specification of the NMF algorithm. Initialized to \code{"brunet"}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{seed} :: \code{character(1)} | \code{integer(1)} | \code{list()} | object of class \code{NMF} | \verb{function()}\cr
Specification of the starting point.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{nrun} :: \code{integer(1)}\cr
Number of runs to performs. Default is \code{1}.
More than a single run allows for the computation of a consensus matrix which will also be stored in the \verb{$state}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{debug} :: \code{logical(1)}\cr
Whether to toggle debug mode. Default is \code{FALSE}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{keep.all} :: \code{logical(1)}\cr
Whether all factorizations are to be saved and returned. Default is \code{FALSE}.
Only has an effect if \code{nrun > 1}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{parallel} :: \code{character(1)} | \code{integer(1)} | \code{logical(1)}\cr
Specification of parallel handling if \code{nrun > 1}.
Initialized to \code{FALSE}, as it is recommended to use \code{mlr3}'s \code{future}-based parallelization.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{parallel.required} :: \code{character(1)} | \code{integer(1)} | \code{logical(1)}\cr
Same as \code{parallel}, but an error is thrown if the computation cannot be performed in parallel or
with the specified number of processors.
Initialized to \code{FALSE}, as it is recommended to use \code{mlr3}'s \code{future}-based parallelization.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{shared.memory} :: \code{logical(1)}\cr
Whether shared memory should be enabled.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{simplifyCB} :: \code{logical(1)}\cr
Whether callback results should be simplified. Default is \code{TRUE}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{track} :: \code{logical(1)}\cr
Whether error tracking should be enabled. Default is \code{FALSE}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{verbose} :: \code{integer(1)} | \code{logical(1)}\cr
Specification of verbosity. Default is \code{FALSE}.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{pbackend} :: \code{character(1)} | \code{integer(1)} | \code{NULL}\cr
Specification of the parallel backend.
It is recommended to use \code{mlr3}'s \code{future}-based parallelization.
See \code{\link[NMF:nmf]{nmf()}}.
\item \code{callback} | \verb{function()}\cr
Callback function that is called after each run (if \code{nrun > 1}).
See \code{\link[NMF:nmf]{nmf()}}.
}
}

\section{Internals}{

Uses the \code{\link[NMF:nmf]{nmf()}} function as well as \code{\link[NMF:basis-coef-methods]{basis()}}, \code{\link[NMF:basis-coef-methods]{coef()}} and
\code{\link[MASS:ginv]{ginv()}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
\dontshow{ if (requireNamespace("NMF")) \{ }
\dontshow{ if (requireNamespace("MASS")) \{ }
if (requireNamespace("NMF")) {
library("mlr3")

task = tsk("iris")
pop = po("nmf")

task$data()
pop$train(list(task))[[1]]$data()

pop$state
}
\dontshow{ try(rm("format.list", envir = .BaseNamespaceEnv$.__S3MethodsTable__.), silent = TRUE)  # BiocGenerics overwrites printer for our tables mlr-org/mlr3#1112 }
\dontshow{ \} }
\dontshow{ \} }
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}
}
\concept{PipeOps}
