% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_branch.R
\name{mlr_graphs_branching}
\alias{mlr_graphs_branching}
\alias{pipeline_branch}
\title{Branch Between Alternative Paths}
\usage{
pipeline_branch(graphs, prefix_branchops = "", prefix_paths = FALSE)
}
\arguments{
\item{graphs}{\code{list} of \code{\link{Graph}} \cr
Multiple graphs, possibly named. They all must have exactly
one output. If any of the arguments are named, then all must have
unique names.}

\item{prefix_branchops}{\code{character(1)} \cr
Optional id prefix to prepend to \code{\link{PipeOpBranch}} and \code{\link{PipeOpUnbranch}} id. Their
resulting IDs will be \code{"[prefix_branchops]branch"} and \code{"[prefix_branchops]unbranch"}.
Default is \code{""}.}

\item{prefix_paths}{\code{logical(1)} | \code{character(1)} \cr
Whether to add prefixes to graph IDs when performing gunion. Can be helpful to
avoid ID clashes in resulting graph. Default \code{FALSE}. If this is \code{TRUE}, the prefixes
are taken from the names of the input arguments if present or \code{"poX"} where X counts up. If this is
a \code{character(1)}, it is a prefix that is added to the \code{PipeOp} IDs \emph{additionally}
to the input argument list.}
}
\value{
\code{\link{Graph}}
}
\description{
Create a multiplexed graph.

All input arguments are cloned and have no references in common with the returned \code{\link{Graph}}.
}
\examples{
library("mlr3")

po_pca = po("pca")
po_nop = po("nop")

branches = pipeline_branch(list(pca = po_pca, nothing = po_nop))
# gives the same as
branches = c("pca", "nothing")
po("branch", branches) \%>>\%
  gunion(list(po_pca, po_nop)) \%>>\%
  po("unbranch", branches)

pipeline_branch(list(pca = po_pca, nothing = po_nop),
  prefix_branchops = "br_", prefix_paths = "xy_")
# gives the same as
po("branch", branches, id = "br_branch") \%>>\%
  gunion(list(xy_pca = po_pca, xy_nothing = po_nop)) \%>>\%
  po("unbranch", branches, id = "br_unbranch")
}
