% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_csv.R
\name{import_csv}
\alias{import_csv}
\title{Flexible \code{CSV}/\code{TXT} File Import with Multiple Backend Support}
\usage{
import_csv(
  file,
  package = "data.table",
  rbind = TRUE,
  rbind_label = "_file",
  ...
)
}
\arguments{
\item{file}{A \code{character} vector of file paths to \code{CSV} files.
Must point to existing and accessible files.}

\item{package}{A \code{character} string specifying the backend package:
\itemize{
\item \code{"data.table"}: Uses \code{\link[data.table:fread]{data.table::fread()}} (default)
\item \code{"arrow"}: Uses \code{\link[arrow:read_delim_arrow]{arrow::read_csv_arrow()}}
Determines the underlying reading mechanism.
}}

\item{rbind}{A \code{logical} value controlling data combination strategy:
\itemize{
\item \code{TRUE}: Combines all files into a single data object
\item \code{FALSE}: Returns a list of individual data objects
Default is \code{TRUE}.
}}

\item{rbind_label}{A \code{character} string or \code{NULL} for source file tracking:
\itemize{
\item \code{character}: Specifies the column name for file source labeling
\item \code{NULL}: Disables source file tracking
Default is \code{"_file"}.
}}

\item{...}{Additional arguments passed to backend-specific reading functions
(e.g., \code{col_types}, \code{na.strings}, \code{skip}).}
}
\value{
Depends on the \code{rbind} parameter:
\itemize{
\item If \code{rbind = TRUE}: A single data object (from chosen package)
containing all imported data
\item If \code{rbind = FALSE}: A named list of data objects with names
derived from input file names (without extensions)
}
}
\description{
A comprehensive \code{CSV} or \code{TXT} file import function offering advanced reading capabilities
through \code{data.table} and \code{arrow} packages with intelligent data combination strategies.
}
\details{
The function provides a unified interface for reading CSV files using either data.table
or arrow package. When reading multiple files, it can either combine them into a single
data object or return them as a list. File source tracking is supported through the
rbind_label parameter.
}
\note{
Critical Import Considerations:
\itemize{
\item Requires all specified files to be accessible \code{CSV/TXT} files
\item Supports flexible backend selection
\item \code{rbind = TRUE} assumes compatible data structures
\item Missing columns are automatically aligned
\item File extensions are automatically removed in tracking columns
}
}
\examples{
# Example: CSV file import demonstrations

# Setup test files
csv_files <- mintyr_example(
  mintyr_examples("csv_test")     # Get example CSV files
)

# Example 1: Import and combine CSV files using data.table
import_csv(
  csv_files,                      # Input CSV file paths
  package = "data.table",         # Use data.table for reading
  rbind = TRUE,                   # Combine all files into one data.table
  rbind_label = "_file"           # Column name for file source
)

# Example 2: Import files separately using arrow
import_csv(
  csv_files,                      # Input CSV file paths
  package = "arrow",              # Use arrow for reading
  rbind = FALSE                   # Keep files as separate data.tables
)
}
\seealso{
\itemize{
\item \code{\link[data.table:fread]{data.table::fread()}} for \code{data.table} backend
\item \code{\link[arrow:read_delim_arrow]{arrow::read_csv_arrow()}} for \code{arrow} backend
\item \code{\link[data.table:rbindlist]{data.table::rbindlist()}} for data combination
}
}
