% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq.R
\name{readFastq}
\alias{readFastq}
\title{Read FASTQ files}
\usage{
readFastq(in.file)
}
\arguments{
\item{in.file}{url/directory/name of FASTQ file to read.}
}
\value{
\code{\link{readFastq}} returns a \code{Fasta} object with the header and sequence part of the 
FASTQ file.
}
\description{
Reads biological sequences (DNA) in the FASTQ format.
}
\details{
The FASTQ format is typically used for storing DNA sequences (reads) together
with quality scores from a sequencer. Reading a FASTQ-file with this function will result
in ignoring the quality score string, and the sequences are stored in a \code{Fasta}
object.

This function uses the \code{\link{readBStringSet}} function of the \code{Biostrings} package.
}
\examples{
\dontrun{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fastq")
fdta <- readFastq(ex.file)
summary(fdta)
}

}
\author{
Lars Snipen.
}
\seealso{
\code{\link{readFasta}}, \code{\link{plot.Fasta}}, \code{\link{summary.Fasta}}.
}
\keyword{FASTQ}
\keyword{Fastq}
\keyword{sequence}

