% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplification.R
\name{get.quantity.of.information}
\alias{get.quantity.of.information}
\title{Get the quantity of information associated with each element of the triangulation, from an object of class \code{RcppSimplification}.}
\usage{
get.quantity.of.information(x)
}
\arguments{
\item{x}{An object of class \code{RcppSimplification}.}
}
\value{
A #elements-by-1 vector, storing the quantity of information for each element.
}
\description{
For each triangle \eqn{T} in the mesh, the associated quantity of information \eqn{N_T} is defined as: \deqn{N_T := n_f + \frac{1}{2}n_e + \frac{1}{\# \big( T_{v_1} \big)} n_1 + \frac{1}{\# \big( T_{v_2} \big)} n_2 + \frac{1}{\# \big( T_{v_3} \big)} n_3 \, ,} where \eqn{n_f} and \eqn{n_e} denote the number of data points associated with the face and the edges of the triangle \eqn{T}, respectively. For \eqn{j = 1, \, 2, \, 3}, \eqn{n_j} is the number of data points associated with the \eqn{j}-th vertex \eqn{v_j} of \eqn{T}, \eqn{T_{v_j}} is the patch of elements associated with \eqn{v_j} (i.e., the elements sharing \eqn{v_j}), and \eqn{\# \big( T_{v_j} \big)} denotes the cardinality of the patch \eqn{T_{v_j}}.
}
\seealso{
\code{\link{simplify.mesh.2.5D}}
}
