% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsirm1pl_normal_o.R
\name{lsirm1pl_normal_o}
\alias{lsirm1pl_normal_o}
\title{1PL LSIRM with normal likelihood.}
\usage{
lsirm1pl_normal_o(
  data,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_gamma = 1,
  jump_z = 0.5,
  jump_w = 0.5,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_mean_gamma = 0.5,
  pr_sd_gamma = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001,
  pr_a_eps = 0.001,
  pr_b_eps = 0.001,
  verbose = FALSE
)
}
\arguments{
\item{data}{Matrix; a binary or continuous item response matrix for analysis. Each row represents a respondent, and each column contains responses to the corresponding item.}

\item{ndim}{Integer; the dimension of the latent space. Default is 2.}

\item{niter}{Integer; the total number of MCMC iterations to run. Default is 15000.}

\item{nburn}{Integer; the number of initial MCMC iterations to discard as burn-in. Default is 2500.}

\item{nthin}{Integer; the number of MCMC iterations to thin. Default is 5.}

\item{nprint}{Integer; the interval at which MCMC samples are displayed during execution. Default is 500.}

\item{jump_beta}{Numeric; the jumping rule for the beta proposal density. Default is 0.4.}

\item{jump_theta}{Numeric; the jumping rule for the theta proposal density. Default is 1.0.}

\item{jump_gamma}{Numeric; the jumping rule for the gamma proposal density. Default is 0.025}

\item{jump_z}{Numeric; the jumping rule for the z proposal density. Default is 0.5.}

\item{jump_w}{Numeric; the jumping rule for the w proposal density. Default is 0.5.}

\item{pr_mean_beta}{Numeric; the mean of the normal prior for beta. Default is 0.}

\item{pr_sd_beta}{Numeric; the standard deviation of the normal prior for beta. Default is 1.0.}

\item{pr_mean_theta}{Numeric; the mean of the normal prior for theta. Default is 0.}

\item{pr_mean_gamma}{Numeric; mean of log normal prior for gamma. Default is 0.5.}

\item{pr_sd_gamma}{Numeric; standard deviation of log normal prior for gamma. Default is 1.0.}

\item{pr_a_theta}{Numeric; the shape parameter of the inverse gamma prior for the variance of theta. Default is 0.001.}

\item{pr_b_theta}{Numeric; the scale parameter of the inverse gamma prior for the variance of theta. Default is 0.001.}

\item{pr_a_eps}{Numeric; the shape parameter of inverse gamma prior for variance of data likelihood. Default is 0.001.}

\item{pr_b_eps}{Numeric; the scale parameter of inverse gamma prior for variance of data likelihood. Default is 0.001.}

\item{verbose}{Logical; If TRUE, MCMC samples are printed for each \code{nprint}. Default is FALSE.}
}
\value{
\code{lsirm1pl_normal_o} returns an object of  list containing the following components:
\item{data}{Data frame or matrix containing the variables used in the model.}
\item{bic}{A numeric value representing the Bayesian Information Criterion (BIC).}
\item{mcmc_inf}{Details about the number of MCMC iterations, burn-in periods, and thinning intervals.}
\item{map_inf}{The log maximum a posteriori (MAP) value and the iteration number at which this MAP value occurs.}
\item{beta_estimate}{Posterior estimates of the beta parameter.}
\item{theta_estimate}{Posterior estimates of the theta parameter.}
\item{sigma_theta_estimate}{Posterior estimates of the standard deviation of theta.}
\item{gamma_estimate}{Posterior estimates of gamma parameter.}
\item{z_estimate}{Posterior estimates of the z parameter.}
\item{w_estimate}{Posterior estimates of the w parameter.}
\item{beta}{Posterior samples of the beta parameter.}
\item{theta}{Posterior samples of the theta parameter.}
\item{theta_sd}{Posterior samples of the standard deviation of theta.}
\item{gamma}{Posterior samples of the gamma parameter.}
\item{z}{Posterior samples of the z parameter, represented as a 3-dimensional matrix where the last axis denotes the dimension of the latent space.}
\item{w}{Posterior samples of the w parameter, represented as a 3-dimensional matrix where the last axis denotes the dimension of the latent space.}
\item{accept_beta}{Acceptance ratio for the beta parameter.}
\item{accept_theta}{Acceptance ratio for the theta parameter.}
\item{accept_z}{Acceptance ratio for the z parameter.}
\item{accept_w}{Acceptance ratio for the w parameter.}
\item{accept_gamma}{Acceptance ratio for the gamma parameter.}
 \item{sigma_estimate}{Posterior estimates of the standard deviation.}
 \item{sigma}{Posterior samples of the standard deviation.}
}
\description{
\link{lsirm1pl_normal_o} is used to fit LSIRM for continuous variable with 1pl.
\link{lsirm1pl_normal_o} factorizes continuous item response matrix into column-wise item effect, row-wise respondent effect and further embeds interaction effect in a latent space. The resulting latent space provides an interaction map that represents interactions between respondents and items.
}
\details{
\code{lsirm1pl_normal_o} models the continuous value of response by respondent \eqn{j} to item \eqn{i} with item effect \eqn{\beta_i}, respondent effect \eqn{\theta_j} and the distance between latent position \eqn{w_i} of item \eqn{i} and latent position \eqn{z_j} of respondent \eqn{j} in the shared metric space, with \eqn{\gamma} represents the weight of the distance term: \deqn{Y_{j,i} = \theta_j+\beta_i-\gamma||z_j-w_i|| + e_{j,i}} where the error \eqn{e_{j,i} \sim N(0,\sigma^2)}.
}
\examples{
# generate example (continuous) item response matrix
data     <- matrix(rnorm(500, mean = 0, sd = 1),ncol=10,nrow=50)

lsirm_result <- lsirm1pl_normal_o(data)

# The code following can achieve the same result.
lsirm_result <- lsirm(data ~ lsirm1pl(spikenslab = FALSE, fixed_gamma = FALSE))

}
