#' Item parameter estimates for 2012 PISA mathematics assessment
#'
#' A dataset containing the estimated item parameters for the PISA 2012 
#' mathematics assessment.
#'
#' @format A data frame with 109 rows and 5 variables:
#' \describe{
#'   \item{item_name}{Item name.}
#'   \item{item}{Item number.}
#'   \item{b}{b parameter estimate.}
#'   \item{d1}{d1 parameter estimate (for partial credit items).}
#'   \item{d2}{d2 parameter estimate (for partial credit items).}
#' }
#' 
#' @source PISA 2012 Technical Report, ANNEX A.
#'         Table A.1: PISA 2012 Main Survey mathematics item classification. 
#'         Pages 406 - 409.
#'         \url{https://www.oecd.org/pisa/pisaproducts/PISA-2012-technical-report-final.pdf}
#' 
"pisa2012_math_item"