% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mjoint.R
\name{summary.mjoint}
\alias{summary.mjoint}
\title{Summary of an \code{mjoint} object}
\usage{
\method{summary}{mjoint}(object, bootSE = NULL, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{mjoint} for a joint model
of time-to-event and multivariate longitudinal data.}

\item{bootSE}{an object inheriting from class \code{bootSE} for the
corresponding model. If \code{bootSE = NULL}, the function will attempt to
utilize approximate standard error estimates (if available) calculated from
the empirical information matrix.}

\item{...}{additional arguments; currently none are used.}
}
\value{
A list containing the coefficient matrices for the longitudinal and
  time-to-event sub-models; variance-covariance matrix for the random
  effects; residual error variances; log-likelihood of joint model; AIC and
  BIC statistics; and model fit objects.
}
\description{
This function provides a summary of an \code{mjoint} object.
}
\examples{
\dontrun{
# Fit a joint model with bivariate longitudinal outcomes

data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]

fit2 <- mjoint(
    formLongFixed = list("grad" = log.grad ~ time + sex + hs,
                         "lvmi" = log.lvmi ~ time + sex),
    formLongRandom = list("grad" = ~ 1 | num,
                          "lvmi" = ~ time | num),
    formSurv = Surv(fuyrs, status) ~ age,
    data = list(hvd, hvd),
    inits = list("gamma" = c(0.11, 1.51, 0.80)),
    timeVar = "time",
    verbose = TRUE)
summary(fit2)
}
}
\references{
Wulfsohn MS, Tsiatis AA. A joint model for survival and longitudinal data
measured with error. \emph{Biometrics.} 1997; \strong{53(1)}: 330-339.

Henderson R, Diggle PJ, Dobson A. Joint modelling of longitudinal
measurements and event time data. \emph{Biostatistics.} 2000; \strong{1(4)}:
465-480.

Lin H, McCulloch CE, Mayne ST. Maximum likelihood estimation in the joint
analysis of time-to-event and multiple longitudinal variables. \emph{Stat
Med.} 2002; \strong{21}: 2369-2382.
}
\seealso{
\code{\link{mjoint}}, \code{\link{mjoint.object}}, and
  \code{\link[base]{summary}} for the generic method description.
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{methods}
