% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regroup.R
\name{regroup}
\alias{regroup}
\title{Regroup 'incidence' objects}
\usage{
regroup(x, groups = NULL)
}
\arguments{
\item{x}{An \code{\link[=incidence]{incidence()}} object.}

\item{groups}{The groups to sum over.  If \code{NULL} (default) then the function
ignores all groups.}
}
\description{
This function regroups an \code{\link[=incidence]{incidence()}} object across the specified groups.
The resulting \code{\link[=incidence]{incidence()}} object will contains counts summed over
the groups present in the input.
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE)) {
  withAutoprint({
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    i <- incidence(dat,
                   date_index = date_of_onset,
                   groups = c(gender, hospital))

    i \%>\% regroup()

    i \%>\% regroup(hospital)
  })
}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
