% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-utility.R
\name{geomSD}
\alias{geomSD}
\title{Compute geometric standard deviation}
\usage{
geomSD(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{na.rm}{Logical, should NA value(s) be removed (FALSE by default)?}
}
\value{
Numeric vector of length 1 with geometric mean.
}
\description{
The geometric standard deviation is computed as:
\eqn{\exp(\sigma(log(x)))}, with:
\itemize{
\item{log: natural logarithm}
\item{\eqn{\sigma}: standard deviation}
}
}
\examples{
# geometric standard deviation of a sample from a log normal distribution:
geomSD(rlnorm(n = 1000, meanlog = 0, sdlog = 1))
}
\seealso{
Other stats utility functions: 
\code{\link{cv}()},
\code{\link{geomCV}()},
\code{\link{geomMean}()},
\code{\link{geomSE}()},
\code{\link{se}()}
}
\author{
Laure Cougnaud
}
\concept{stats utility functions}
