% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateDisDrugNet.R
\name{CreateDisDrugNet}
\alias{CreateDisDrugNet}
\title{CreateDisDrugNet}
\usage{
CreateDisDrugNet(BasicData, drug, disease)
}
\arguments{
\item{BasicData}{BasicData object.}

\item{drug}{Character vector, the drug.}

\item{disease}{Character vector, the disease.}
}
\value{
A igraph object.
}
\description{
Create Disease-Drug Network
}
\examples{
data(drugdemo)
drug_herb <- PrepareData(drugdemo$drug_herb, from = "drug", to="herb")
herb_compound <- PrepareData(drugdemo$herb_compound, from = "herb", to="compound")
compound_target <- PrepareData(drugdemo$compound_target, from = "compound", to="target")
disease <- PrepareData(drugdemo$disease, diseaseID = "disease",from = "target", to="target")
BasicData <- CreateBasicData(drug_herb, herb_compound, compound_target, diseasenet = disease)
DisDrugNet <- CreateDisDrugNet(BasicData, drug = "Drug1", disease = "disease")
}
\author{
Yuanlong Hu
}
