% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-options.R
\name{req_proxy}
\alias{req_proxy}
\title{Use a proxy for a request}
\usage{
req_proxy(
  req,
  url,
  port = NULL,
  username = NULL,
  password = NULL,
  auth = "basic"
)
}
\arguments{
\item{req}{A \link{request}.}

\item{url, port}{Location of proxy.}

\item{username, password}{Login details for proxy, if needed.}

\item{auth}{Type of HTTP authentication to use. Should be one of the
following: \code{basic}, digest, digest_ie, gssnegotiate, ntlm, any.}
}
\description{
Use a proxy for a request
}
\examples{
# Proxy from https://www.proxynova.com/proxy-server-list/
\dontrun{
request("http://hadley.nz") \%>\%
  req_proxy("20.116.130.70", 3128) \%>\%
  req_perform()
}
}
