% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wambaugh2019.tox21}
\alias{wambaugh2019.tox21}
\title{Tox21 2015 Active Hit Calls (EPA)}
\format{
A data.table with 401 rows and 6 columns
}
\usage{
wambaugh2019.tox21
}
\description{
The ToxCast and Tox21 research programs employ batteries of high-throughput
assays to assess chemical bioactivity in vitro. Not every chemical is tested
through every assay. Most assays are conducted in concentration response,
and each corresponding assay endpoint is analyzed statistically to determine
if there is a concentration-dependent response or "hit" using the ToxCast
Pipeline.  Most assay endpoint-chemical combinations are non-responsive.
Here, only the hits are treated as potential indicators of bioactivity. This
bioactivity does not have a direct toxicological interpretation. The October
2015 release (invitrodb_v2) of the ToxCast and Tox21 data were used for this
analysis. This object contains just the chemicals in Wambaugh et al. (2019)
and only the quantiles across all assays for the ACC.
}
\references{
Kavlock, Robert, et al. "Update on EPA's ToxCast program:
providing high-throughput decision support tools for chemical risk
management." Chemical research in toxicology 25.7 (2012): 1287-1302.

Tice, Raymond R., et al. "Improving the human hazard characterization of
chemicals: a Tox21 update." Environmental health perspectives 121.7 (2013):
756-765.

Richard, Ann M., et al. "ToxCast chemical landscape: paving the road to 21st
century toxicology." Chemical research in toxicology 29.8 (2016): 1225-1251.

Filer, Dayne L., et al. "tcpl: the ToxCast pipeline for high-throughput
screening data." Bioinformatics 33.4 (2016): 618-620.

Wambaugh, John F., et al. "Assessing Toxicokinetic Uncertainty and 
Variability in Risk Prioritization." Toxicological Sciences 172.2 (2019): 
235-251.
}
\author{
John Wambaugh
}
\keyword{data}
