% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isFunctions.R
\name{is.greybox}
\alias{is.greybox}
\alias{is.alm}
\alias{is.occurrence}
\alias{is.greyboxC}
\alias{is.greyboxD}
\alias{is.rollingOrigin}
\alias{is.rmc}
\alias{is.scale}
\title{Greybox classes checkers}
\usage{
is.greybox(x)

is.alm(x)

is.occurrence(x)

is.greyboxC(x)

is.greyboxD(x)

is.rollingOrigin(x)

is.rmc(x)

is.scale(x)
}
\arguments{
\item{x}{The object to check.}
}
\value{
\code{TRUE} if this is the specified class and \code{FALSE} otherwise.
}
\description{
Functions to check if an object is of the specified class
}
\details{
The list of functions includes:
\itemize{
\item \code{is.greybox()} tests if the object was produced by a greybox function
(e.g. \link[greybox]{alm} / \link[greybox]{stepwise} / \link[greybox]{lmCombine}
/ \link[greybox]{lmDynamic});
\item \code{is.alm()} tests if the object was produced by \code{alm()} function;
\item \code{is.occurrence()} tests if an occurrence part of the model was produced;
\item \code{is.greyboxC()} tests if the object was produced by \code{lmCombine()}
function;
\item \code{is.greyboxD()} tests if the object was produced by \code{lmDynamic()}
function;
\item \code{is.rmc()} tests if the object was produced by \code{rmc()} function;
\item \code{is.rollingOrigin()} tests if the object was produced by \code{ro()}
function;
\item \code{is.scale()} tests if the object is of the class "scale" (produced by
alm in case of heteroscedastic model);
}
}
\examples{

xreg <- cbind(rlaplace(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rlaplace(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

ourModel <- alm(y~x1+x2, xreg, distribution="dnorm")

is.alm(ourModel)
is.greybox(ourModel)
is.greyboxC(ourModel)
is.greyboxD(ourModel)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ts}
\keyword{univar}
