\name{getSjjGLPK}
\alias{getSjjGLPK}
\alias{glp_get_sjj}

\title{
  Retrieve column scale factor
}

\description{
  Low level interface function to the GLPK function \code{glp_get_sjj}.
  Consult the GLPK documentation for more detailed information.
}

\usage{
  getSjjGLPK(lp, j)
}

\arguments{
  \item{lp}{
    A pointer to a GLPK problem object.
  }
  \item{j}{
    Column number j.
  }
}

\details{
  Interface to the C function \code{getSjj} which calls the GLPK
  function \code{glp_get_sjj}.
}

\value{
  Returns the current scale factor $s_{jj}$ for column \code{j} of the
  specified problem object.
}

\references{
  Based on the package \pkg{glpk} by Lopaka Lee.
    
  The GNU GLPK home page at \url{http://www.gnu.org/software/glpk/glpk.html}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }
