% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_example_data}
\alias{get_example_data}
\title{Returns example data for package}
\usage{
get_example_data(
  which_data,
  data_dir = system.file("extdata", package = "gimap"),
  refresh_data = FALSE
)
}
\arguments{
\item{which_data}{options are "count" or "meta"; specifies which example dataset should be returned}

\item{data_dir}{Where should the data be saved if applicable?}

\item{refresh_data}{should the example data that's been downloaded be deleted
and redownloaded?}
}
\value{
the respective example data either as a data frame or a specialized
gimap_dataset depending on what was requested.
}
\description{
This function loads and returns example data for the package.
Which dataset is returned must be specified. Data will be downloaded from Figshare
the first time it is used.
}
\examples{
\dontrun{

counts_timepoint <- get_example_data("count")
counts_treatment <- get_example_data("count_treatment")
gimap_timepoint_dataset <- get_example_data("gimap")
gimap_treatment_dataset <- get_example_data("gimap_treatment")
metadata <- get_example_data("meta")
annotation <- get_example_data("annotation")
}
}
