% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_gghistostats.R
\name{histo_labeller}
\alias{histo_labeller}
\title{Custom function for adding labelled lines for \code{x}-axis variable.}
\usage{
histo_labeller(plot, x, y.label.position, centrality.para = "mean",
  centrality.color = "blue", centrality.size = 1,
  centrality.linetype = "dashed", centrality.line.labeller = TRUE,
  centrality.k = 2, test.value = 0, test.value.line = FALSE,
  test.value.color = "black", test.value.size = 1,
  test.value.linetype = "dashed", test.line.labeller = TRUE,
  test.k = 0)
}
\arguments{
\item{plot}{A \code{ggplot} object for which the labelled lines need to be
added for a test value and/or a centrality parameter (mean/median) value.}

\item{x}{A numeric variable.}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as a vertical line.}

\item{centrality.color}{Decides color for the vertical line for centrality
parameter (Default: \code{"blue"}).}

\item{centrality.size}{Decides size for the vertical line for centrality
parameter (Default: \code{1.2}).}

\item{centrality.linetype}{Decides linetype for the vertical line for
centrality parameter (Default: \code{"dashed"}).}

\item{centrality.line.labeller}{A logical that decides whether line labels
should be displayed for the \strong{centrality.para} line (Default: \code{TRUE}).}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{test.value.line}{Decides whether test value is to be displayed as a
vertical line (Default: \code{FALSE}).}

\item{test.value.color}{Decides color for the vertical line denoting test
value (Default: \code{"black"}).}

\item{test.value.size}{Decides size for the vertical line for test value
(Default: \code{1.2}).}

\item{test.value.linetype}{Decides linetype for the vertical line for test
value (Default: \code{"dashed"}).}

\item{test.line.labeller}{A logical that decides whether line labels should
be displayed for \strong{test.value} line (Default: \code{TRUE}).}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}
}
\description{
Helper function for adding centrality parameter value and/or a
test value for the continuous, numeric \code{x}-axis variable.
}
\examples{
\donttest{
library(ggplot2)

# creating a ploton which lines and labels are to be superposed
p <- ggplot(mtcars, aes(wt, mpg)) + geom_point()

# computing `y`-axis positions for line labels
y_label_pos <- median(
  x = ggplot2::layer_scales(p)$y$range$range,
  na.rm = TRUE
)
# adding labels
ggstatsplot:::histo_labeller(
  plot = p,
  x = mtcars$wt,
  y.label.position = y_label_pos,
  test.value.line = TRUE
)
}

}
\author{
Indrajeet Patil
}
\keyword{internal}
