% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-spikes.R
\name{find_spikes}
\alias{find_spikes}
\title{Find spikes}
\usage{
find_spikes(
  x,
  x.is.delta = FALSE,
  z.threshold = 9,
  max.spike.width = 8,
  na.rm = FALSE
)
}
\arguments{
\item{x}{numeric vector containing spectral data.}

\item{x.is.delta}{logical Flag indicating if x contains already differences.}

\item{z.threshold}{numeric Modified Z values larger than \code{z.threshold}
are considered to be spikes.}

\item{max.spike.width}{integer Wider regions with high Z values are not detected as
spikes.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for spikes.}
}
\value{
A logical vector of the same length as \code{x}. Values that are TRUE
  correspond to local spikes in the data.
}
\description{
This function finds spikes in a numeric vector using the algorithm of
Whitaker and Hayes (2018). Spikes are values in spectra that are unusually
high or low compared to neighbours. They are usually individual values or very
short runs of similar "unusual" values. Spikes caused by cosmic radiation are
a frequent problem in Raman spectra. Another source of spikes are "hot
pixels" in CCD and diode arrays. Other kinds of accidental "outlayers" are
be also detected.
}
\details{
Spikes are detected based on a modified Z score calculated from the
  differenced spectrum. The Z threshold used should be adjusted to the
  characteristics of the input and desired sensitivity. The lower the
  threshold the more stringent the test becomes, resulting in most cases in
  more spikes being detected. A modified version of the algorithm is used if
  a value different from \code{NULL} is passed as argument to
  \code{max.spike.width}. In such a case, an additional step filters out
  broader spikes (or falsely detected steep slopes) from the returned values.
}
\references{
Whitaker, D. A.; Hayes, K. (2018) A simple algorithm for despiking Raman
spectra. Chemometrics and Intelligent Laboratory Systems, 179, 82-84.
}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()}
}
\concept{peaks and valleys functions}
