% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-geom-rect3d.R
\name{scale_z_continuous}
\alias{scale_z_continuous}
\alias{scale_z_binned}
\alias{scale_z_discrete}
\alias{scale_z_ordinal}
\alias{scale_z_datetime}
\alias{scale_z_date}
\title{z scales}
\usage{
scale_z_continuous(name = waiver(), ..., range = c(0.1, 1), guide = "none")

scale_z_binned(name = waiver(), ..., range = c(0.1, 1), guide = "none")

scale_z_discrete(...)

scale_z_ordinal(name = waiver(), ..., range = c(0.1, 1), guide = "none")
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{...}{Other arguments passed on to
\code{\link[ggplot2:continuous_scale]{continuous_scale()}},
\code{\link[ggplot2:binned_scale]{binned_scale()}}, or
\code{\link[ggplot2:discrete_scale]{discrete_scale()}} as appropriate, to control
name, limits, breaks, labels and so forth.}

\item{range}{Output range of z values. Must larger than 0.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\description{
z scales
}
\examples{

set.seed(7)
mat <- matrix(runif(100), 10)
rownames(mat) <- LETTERS[1:10]
colnames(mat) <- letters[1:10]
ggheatmap(mat,
    filling = FALSE,
    theme = theme(
        legend.box.spacing = unit(10, "mm"),
        plot.margin = margin(t = 15, unit = "mm")
    )
) +
    geom_tile3d(aes(fill = value, z = value, width = 0.8, height = 0.8)) +
    scale_z_continuous(range = c(0.2, 1)) +
    coord_cartesian(clip = "off")
}
\seealso{
\code{\link[=geom_tile3d]{geom_tile3d()}}/\code{\link[=geom_rect3d]{geom_rect3d()}}
}
