% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somePairs.R
\name{somePairs}
\alias{somePairs}
\title{Function reporting kernel causality results as a 7-column matrix.}
\usage{
somePairs(mtx, dig = 6, verbo = FALSE, typ = 1, rnam = FALSE)
}
\arguments{
\item{mtx}{{The data matrix in the first column is paired with all others.}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}

\item{verbo}{{Make \code{verbo= TRUE} for printing detailed steps.}}

\item{typ}{{Must be 1 (default), 2 or 3 for the three criteria.}}

\item{rnam}{{Make \code{rnam= TRUE} if cleverly created rownames are desired.}}
}
\value{
A matrix containing causal identification results.  The last matrix
outVote reports summary results for all three criteria in column `sum'.
}
\description{
Three criteria are used optinally by specifying typ as 1, 2 or 3.  One considers
only one criterion at a time unlike the function \code{some0Pairs} which
summarizes the resulting signs for all criteria with suitable weights:
}
\details{
(typ=1) reports ('Y', 'X', 'Cause',
'SD1apd', 'SD2apd', 'SD3apd', 'SD4apd') nameing variables identifying 'cause'
and measures of stochastic dominance using absolute values of kernel
regression gradients comparing regresson of X on Y with that of Y on X.

{(typ=2)} 
 reports ('Y', 'X', 'Cause', 'SD1res', 'SD2res', 'SD3res', 'SD4res')
 and measures of stochastic dominance using absolute values of kernel
 regression residuals comparing regresson of X on Y with that of Y on X.

{(typ=3)} 
reports ('Y', 'X', 'Cause', 'r*X|Y', 'r*Y|X', 'r', 'p-val')
containing generalized correlation coefficients r*, 'r' refers to the
Pearson correlation coefficient and p-val column has the p-values for 
testing the significance of Pearson's 'r'
}
\examples{

\dontrun{
data(mtcars)
somePairs(mtcars)
}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
H. D. Vinod 'Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
See Also \code{\link{some0Pairs}}.
}
\keyword{SD1,}
\keyword{SD2,}
\keyword{SD3,}
\keyword{SD4,}
\keyword{causal}
\keyword{correlations}
\keyword{criteria,}
\keyword{generalized}

