% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canopy-height.R
\name{fd_canopy_height}
\alias{fd_canopy_height}
\title{Forest Canopy Height}
\usage{
fd_canopy_height(
  x = NULL,
  lon = NULL,
  lat = NULL,
  model = "eth",
  layer = "chm",
  crop = FALSE,
  mask = FALSE,
  merge = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{a \code{sf} or \code{SpatVector} object. It will retrieve the
necessary tiles to cover the area (if \code{lat} and \code{lon} are
specified, this argument is ignored)}

\item{lon}{a number specifying the longitude of the area where we want the tile}

\item{lat}{a number specifying the latitude of the area where we want the tile}

\item{model}{a string specifying the model to download. One of "\code{eth}"
or "\code{meta}" (see details)}

\item{layer}{a string for the layer to download (valid only for eth). The default "\code{chm}"
downloads the Canopy Height Model, while "\code{std}" downloads the standard
deviation. If you want both layers, use "\code{all}"}

\item{crop}{when \code{x} is specified, whether to crop the tile(s) to the object}

\item{mask}{when \code{x} is specified, whether to mask the tile(s) to the object}

\item{merge}{if \code{FALSE} (default), it will merge the tiles into one raster.
If \code{FALSE} a SpatRasterCollection will be returned.}

\item{quiet}{if \code{TRUE}, suppress any message or progress bar}
}
\value{
A \code{SpatRaster} or \code{SpatRasterCollection}
}
\description{
Download the ETH Global Sentinel-2 10m Canopy Height (2020) or the
Meta High Resolution 1m Global Canopy Height Map
}
\details{
There are currently two global canopy height models available within this function.
\itemize{
\item \strong{eth}: the ETH Global Sentinel-2 10m Canopy Height from the year 2020. Visit
\url{https://www.research-collection.ethz.ch/handle/20.500.11850/609802} for more
information
\item \strong{meta}: the Meta High Resolution 1m Global Canopy Height. Visit
\doi{10.1016/j.rse.2023.113888} for more information
}

Data may be freely used for research, study, or teaching, but be cited
appropriately (see references below).
}
\examples{
\dontrun{
## Get 10m resolution CHM
eth_model <- fd_canopy_height(lon = -7.27, lat = 42.43)

## Get 1m resolution CHM
meta_model <- fd_canopy_height(lon = -7.27, lat = 42.43, model = "meta")
}
}
\references{
Lang, Nico, Walter Jetz, Konrad Schindler, and Jan Dirk Wegner.
"A high-resolution canopy height model of the Earth." arXiv preprint arXiv:2204.08322 (2022).

Tolan, J., Yang, H.I., Nosarzewski, B., Couairon, G., Vo, H.V., Brandt, J., Spore, J., Majumdar, S., Haziza, D., Vamaraju, J. and Moutakanni, T.,
2024. Very high resolution canopy height maps from RGB imagery using self-supervised vision transformer and convolutional decoder trained on aerial
lidar. Remote Sensing of Environment, 300, p.113888.
}
