% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secDetails.R
\name{fmpc_security_ratings}
\alias{fmpc_security_ratings}
\title{Pull security rating}
\usage{
fmpc_security_ratings(symbols = c("AAPL"), limit = 100)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_available}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{limit}{limit results for each ticker}
}
\value{
data frame of ratings data
}
\description{
Provides current and historical rating for one or more securities
}
\examples{


\dontrun{

# Demo can pull AAPL
fmpc_set_token()
fmpc_security_ratings('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_security_ratings(c('AAPL','MSFT','SPY'))

}

}
