% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitode.R
\name{fitode}
\alias{fitode}
\title{Fit ordinary differential equations model}
\usage{
fitode(
  model,
  data,
  start,
  tcol = "times",
  method = "BFGS",
  optimizer = "optim",
  link,
  fixed = list(),
  prior = list(),
  prior.density = TRUE,
  control = list(maxit = 1e+05),
  solver.opts = list(method = "rk4"),
  solver = ode,
  skip.hessian = FALSE,
  force.hessian = FALSE,
  use.ginv = TRUE,
  quietly = FALSE,
  ...
)
}
\arguments{
\item{model}{odemodel object}

\item{data}{data frame with a time column and observation columns}

\item{start}{named vector of starting parameter values}

\item{tcol}{(character) time column}

\item{method}{optimization method}

\item{optimizer}{optimizer}

\item{link}{named vector or list of link functions for model parameters}

\item{fixed}{named vector or list of model parameters to fix and their values}

\item{prior}{list of formulas specifying prior distributions}

\item{prior.density}{(logical) should priors represent probability distributions?}

\item{control}{see \code{\link{optim}}}

\item{solver.opts}{options for ode integration. See \code{\link{ode}}}

\item{solver}{ode solver}

\item{skip.hessian}{skip hessian calculation}

\item{force.hessian}{(logical) calculate the hessian numerically instead of taking the jacobian of the gradients based on sensitivity equations}

\item{use.ginv}{(logical) use generalized inverse (\code{\link{ginv}}) to compute approximate vcov}

\item{quietly}{suppress progress messages?}

\item{...}{mle2 arguments}
}
\value{
An object of class ``fitode'' as described in \code{\link{fitode-class}}.
}
\description{
This function fits ordinary differential equations models to a uni- or
multi-variate time series by maximum likelihood.
It relies on sensitivity equations to compute
gradients of the estimated trajectory with respect to model parameters.
This allows one to use gradient-based optimization algorithms, which can
provide more robust estimation.
}
\seealso{
\code{\link{mle2}}
}
