% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openfair.R
\name{openfair_tef_tc_diff_lm}
\alias{openfair_tef_tc_diff_lm}
\title{Run an OpenFAIR simulation at the TEF/TC/DIFF/LM levels}
\usage{
openfair_tef_tc_diff_lm(scenario, n = 10^4, title = "Untitled",
  verbose = FALSE)
}
\arguments{
\item{scenario}{List of TEF, TC, and LM parameters.}

\item{n}{Number of simulations to run.}

\item{title}{Optional name of scenario.}

\item{verbose}{Whether to print progress indicators.}
}
\value{
Dataframe of scenario name, threat_event count, loss_event count,
mean TC and DIFF exceedance, and ALE samples.
}
\description{
Run an OpenFAIR model with parameters provided for TEF, TC, DIFF, and
LM sampling. If there are multiple controls provided for a scenarios, the
arithmetic mean (average) is taken across samples for all controls to get
the effective control strength for a given simulation.
}
\examples{
data(quantitative_scenarios)
scenario <- quantitative_scenarios[1, ]
openfair_tef_tc_diff_lm(scenario, 10)
}
\seealso{
Other OpenFAIR helpers: \code{\link{compare_tef_vuln}},
  \code{\link{get_mean_control_strength}},
  \code{\link{sample_diff}}, \code{\link{sample_lef}},
  \code{\link{sample_lm}}, \code{\link{sample_tc}},
  \code{\link{sample_tef}}, \code{\link{sample_vuln}},
  \code{\link{select_loss_opportunities}}
}
\concept{OpenFAIR helpers}
