% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridMetrics.R
\name{gridMetrics}
\alias{gridMetrics}
\title{Grid Metrics}
\usage{
gridMetrics(x, metric, column = NULL, verbose = TRUE)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{metric}{name of metric to use, see Details.}

\item{column}{If a univariate morphological metric is specified, and the data
in \code{x} are multivariate, which trait should be used? This can also
specify which subset of columns a multivariate metric should be applied to.}

\item{verbose}{print various messages to the console. Default is TRUE.}
}
\value{
object of class \code{epmGrid} where the grid represents calculations
 of the metric at every cell. The species identities per grid cell are those
 that had data for the calculation of the metric. If taxa were dropped from
 the initial epmGrid object, then they have been removed from this epmGrid.
 If a set of trees was involved, then returns a list of \code{epmGrid} objects.
}
\description{
Calculate various morphological and phylogenetic community
 metrics for every cell in a \code{epmGrid} object. To implement other 
 metrics not available here, see \code{\link{customGridMetric}}.
}
\details{
Univariate trait metrics 
\itemize{ 
   \item{mean} 
   \item{median}
   \item{range} 
   \item{variance}
   \item{mean_NN_dist:} {mean nearest neighbor distance}
   \item{min_NN_dist:} {minimum nearest neighbor distance}
   \item{evenness:} {variance of nearest neighbor distances, 
			larger values imply decreasing evenness}
   \item{arithmeticWeightedMean} (see below) 
   \item{geometricWeightedMean} (see below) 
}
Multivariate trait metrics 
\itemize{ 
   \item{disparity}
   \item{partialDisparity:} {contribution of species in each gridcell to 
   overall disparity, returned as the ratio of summed partial disparities
   to total disparity.} 
   \item{range} 
   \item{mean_NN_dist:} {mean nearest neighbor distance} 
   \item{min_NN_dist:} {minimum nearest neighbor distance}
   \item{evenness:} {variance of nearest neighbor distances, 
		larger values imply decreasing evenness}
} 
Phylogenetic metrics 
\itemize{ 
    \item{pd:} {Faith's phylogenetic diversity, including the root} 
    \item{meanPatristic}
    \item{meanPatristicNN:} {mean nearest neighbor in patristic distance}
    \item{minPatristicNN:} {minimum nearest neighbor in patristic distance}
    \item{phyloEvenness:} {variance of nearest neighbor patristic distances,
		larger values imply decreasing evenness}
    \item{phyloDisparity:} {sum of squared deviations in patristic distance}
    \item{PSV:} {Phylogenetic Species Variability} 
    \item{PSR:} {Phylogenetic Species Richness} 
    \item{DR:} {non-parametric estimate of speciation rates} 
}
Range-weighted metrics 
\itemize{ 
    \item{weightedEndemism:} {Species richness inversely weighted by range size.}
    \item{correctedWeightedEndemism:} {Weighted endemism standardized by 
    species richness} 
    \item{phyloWeightedEndemism:} {Phylogenetic diversity inversely weighted 
			by range size associated with each phylogenetic branch.} 
}

If data slot contains a pairwise matrix, \code{column} is ignored. Weighted
mean options are available where, for each cell, a weighting scheme (inverse
of species range sizes) is applied such that small-ranged species are
up-weighted, and broadly distributed species are down-weighted. This can be a
useful way to lessen the influence of broadly distributed species in the
geographic mapping of trait data.

It may be desirable to have metrics calculated for a dataset where only taxa
shared across geography, traits and phylogeny are included. The function
\code{\link{reduceToCommonTaxa}} does exactly that.

If a set of trees are associated with the input epmGrid object \code{x}, 
then the metric is calculated for each tree, and a list of epmGrid objects 
is returned. This resulting list can be summarized with the function
\code{\link{summarizeEpmGridList}}. For instance the mean and variance can 
be calculated, to show the central tendency of the metric across grid cells, 
and to quantify where across geography variability in phylogenetic topography
manifests itself.  

To implement other metrics not available here, see
\code{\link{customGridMetric}}.
}
\examples{
tamiasEPM <- addPhylo(tamiasEPM, tamiasTree)
tamiasEPM <- addTraits(tamiasEPM, tamiasTraits)

# univariate morphological example
x <- gridMetrics(tamiasEPM, metric='mean', column='V2')
plot(x)
\donttest{
# multivariate morphological
x <- gridMetrics(tamiasEPM, metric='disparity')
plot(x)

# phylogenetic metrics
x <- gridMetrics(tamiasEPM, metric='meanPatristic')
plot(x)
}
}
\references{
partial disparity\cr Foote, M. (1993). Contributions of individual taxa to
overall morphological disparity. Paleobiology, 19(4), 403–419.
https://doi.org/10.1017/s0094837300014056

PSV, RSV\cr Helmus, M. R., Bland, T. J., Williams, C. K., & Ives, A. R.
(2007). Phylogenetic Measures of Biodiversity. The American Naturalist,
169(3), E68–E83. https://doi.org/10.1086/511334

DR\cr Jetz, W., Thomas, G. H., Joy, J. B., Hartmann, K., & Mooers, A. O.
(2012). The global diversity of birds in space and time. Nature, 491(7424),
444–448. https://doi.org/10.1038/nature11631

weighted endemism\cr Crisp, M. D., Laffan, S., Linder, H. P., & Monro, A.
(2001). Endemism in the Australian flora. Journal of Biogeography, 28(2),
183–198. https://doi.org/10.1046/j.1365-2699.2001.00524.x

phylo weighted endemism\cr Rosauer, D., Laffan, S. W., Crisp, M. D.,
Donnellan, S. C., & Cook, L. G. (2009). Phylogenetic endemism: a new approach
for identifying geographical concentrations of evolutionary history.
Molecular Ecology, 18(19), 4061–4072.
https://doi.org/10.1111/j.1365-294x.2009.04311.x
}
