% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.nests.R
\name{info.nests}
\alias{info.nests}
\title{Calculte statistics about nests}
\usage{
info.nests(
  x = NULL,
  parameters = NULL,
  NestsResult = NULL,
  resultmcmc = NULL,
  hessian = NULL,
  GTRN.CI = NULL,
  fixed.parameters = NULL,
  SE = NULL,
  temperatures = NULL,
  integral = NULL,
  derivate = NULL,
  hatchling.metric = NULL,
  stop.at.hatchling.metric = FALSE,
  M0 = NULL,
  series = "all",
  TSP.borders = NULL,
  embryo.stages = NULL,
  TSP.begin = 0,
  TSP.end = 0.5,
  replicate.CI = 0,
  weight = NULL,
  out = "likelihood",
  WAIC = TRUE,
  fill = NULL,
  probs = c(0.025, 0.5, 0.975),
  SexualisationTRN = NULL,
  SexualisationTRN.mcmc = NULL,
  SexualisationTRN.CI = NULL,
  metric.end.incubation = "observed",
  metabolic.heating = 0,
  temperature.heterogeneity = 0,
  progressbar = FALSE,
  warnings = TRUE,
  parallel = TRUE,
  tsd = NULL,
  tsd.CI = NULL,
  tsd.mcmc = NULL,
  zero = 1e-09,
  verbose = FALSE
)
}
\arguments{
\item{x}{A set of parameters to model the embryo growth thermal reaction norm or a NestsResult object.}

\item{parameters}{A set of parameters to model the embryo growth thermal reaction norm. It will replace the parameters included in NestsResult (same as x).}

\item{NestsResult}{A NestsResult object generated by searchR to model the embryo growth thermal reaction}

\item{resultmcmc}{A mcmc result for embryo growth thermal reaction norm}

\item{hessian}{An hessian matrix for embryo growth thermal reaction norm. It will replace the hessian matrix included in NestResult object.}

\item{GTRN.CI}{How to estimate CI for embryo growth thermal reaction norm; can be NULL, "SE", "MCMC", or "Hessian".}

\item{fixed.parameters}{A set of fixed parameters to model the embryo growth thermal reaction norm. It will replace the fixed parameters included in NestsResult.}

\item{SE}{Standard error for each parameter. It will replace the SE in NestsResult. Use SE=NA to remove SE from NestResult}

\item{temperatures}{Timeseries of temperatures formatted using FormatNests(). It will replace the one in NestsResult.}

\item{integral}{Function used to fit embryo growth: integral.Gompertz, integral.exponential or integral.linear. It will replace the one in NestsResult.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear. It will replace the one in NestsResult.}

\item{hatchling.metric}{Mean and SD of size of hatchlings. It will replace the one in NestsResult.}

\item{stop.at.hatchling.metric}{TRUE or FALSE. If TRUE, the model stops when proxy of size reached the mean hatchling.metric size.}

\item{M0}{Measure of hatchling size proxi at laying date. It will replace the one in NestsResult.}

\item{series}{The name or number of the series to be estimated.}

\item{TSP.borders}{The limits of TSP in stages. See embryo.stages parameter.}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP borders. See note.}

\item{TSP.begin}{Where TSP begin during the stage of beginning? In relative proportion of the stage.}

\item{TSP.end}{Where TSP begin during the stage of ending? In relative proportion of the stage.}

\item{replicate.CI}{Number of replicates to estimate CI. See description}

\item{weight}{Weights of the different nests to estimate likelihood. It will replace the ones in NestsResult.}

\item{out}{Can take the values of "likelihood", "summary", "details", "metric" or "dynamic".}

\item{WAIC}{Should WAIC data be returned?}

\item{fill}{Number of minutes between two records. Create new one if they do not exist. NULL does not change the time of temperature recordings.}

\item{probs}{Probabilities for metric quantiles.}

\item{SexualisationTRN}{A set of parameters used to model sexualisation thermal reaction norm during TSP or a result of STRN()}

\item{SexualisationTRN.mcmc}{A mcmc object obtained from STRN_MHmcmc() to generate variability for sexualisation thermal reaction norm during TSP}

\item{SexualisationTRN.CI}{How to estimate CI of sexualisation thermal reaction norm. Can be NULL, "SE", "MCMC", or "Hessian".}

\item{metric.end.incubation}{The metric at the end of incubation used to calibrate TSP size. Can be "hatchling.metric", or "observed".}

\item{metabolic.heating}{Degrees Celsius to be added at the end of incubation due to metabolic heating.}

\item{temperature.heterogeneity}{SD of heterogeneity of temperatures. Can be 2 values, sd_low and sd_high and then HelpersMG::r2norm() is used.}

\item{progressbar}{If FALSE, the progress bar is not shown (useful for using with sweave or knitr)}

\item{warnings}{If FALSE, does not show warnings}

\item{parallel}{If TRUE use parallel version for nests estimation}

\item{tsd}{A object from tsd() that describe the thermal react norm of sex ratio at constant temperatures}

\item{tsd.CI}{How to estimate CI for sex ratio thermal reaction norm; Can be NULL, "SE", "MCMC", or "Hessian".}

\item{tsd.mcmc}{A object from tsd_MHmcmc() .}

\item{zero}{Value to replace 0 or 1.}

\item{verbose}{If TRUE, show more information.}
}
\value{
Return or the total likelihood or a list with $metric and $summary depending on out parameter
}
\description{
This function calculates many statistics about nests.\cr
The embryo.stages is a named vector with relative size as compared to final size at the beginning of the stage. Names are the stages.\cr
For example for SCL in Caretta caretta:\cr
embryo.stages=structure(c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33), \cr
.Names = c("21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"))\cr
indicates that the stages 21 begins at the relative size of 8.4/39.33 as compared to the final size.\cr
Series can be indicated as the name of the series, their numbers or series or succession of TRUE or FALSE. "all" indicates that all series must be analyzed.\cr
The likelihood object is just the total likelihood of the data in the model.\cr
If one parameter is named "pipping_emergence" it is used as the number of days between pipping and emergence to calculate the 1/3 and 2/3 of incubation.\cr
The summary object is a data.frame composed of these elements with the suffix .mean, .se or .quantile_x with x from the parameter probs.
\itemize{
\item \code{Temperature.max} Maximum temperature recorded during incubation
\item \code{TimeWeighted.temperature} Average temperature during all incubation
\item \code{GrowthWeighted.temperature} Average temperature weighted by the actual growth during all incubation
\item \code{TimeWeighted.GrowthRateWeighted.temperature} Average temperature weighted by the growth rate during all incubation
\item \code{TSP.TimeWeighted.temperature} Average temperature during the TSP
\item \code{TSP.GrowthWeighted.temperature} Average temperature weighted by the actual growth during the TSP
\item \code{TSP.TimeWeighted.GrowthRateWeighted.temperature} Average temperature weighted by the growth rate during the TSP
\item \code{TSP.TimeWeighted.STRNWeighted.temperature} Average temperature weighted by the thermal reaction norm of sexualization during the TSP
\item \code{TSP.GrowthWeighted.STRNWeighted.temperature} Average temperature weighted by actual growth and the thermal reaction norm of sexualization during the TSP
\item \code{TSP.TimeWeighted.GrowthRateWeighted.STRNWeighted.temperature} Average temperature weighted by growth rate and the thermal reaction norm of sexualization during the TSP
\item \code{TSP.length} TSP duration
\item \code{TSP.begin} Beginning of the TSP
\item \code{TSP.end} End of the TSP
\item \code{TSP.PM.GrowthWeighted} Average of male probability for each temperature weighted by actual growth during the TSP
\item \code{TSP.PM.TimeWeighted.GrowthRateWeighted} Average of male probability for each temperature weighted by growth rate during the TSP
\item \code{TSP.PM.TimeWeighted} Average of male probability for each temperature during the TSP
\item \code{Incubation.length} Incubation length duration
\item \code{MiddleThird.length} Middle third incubation duration
\item \code{MiddleThird.begin} Beginning of the middle third incubation duration
\item \code{MiddleThird.end} End of the middle third incubation duration
\item \code{MiddleThird.TimeWeighted.temperature} Average temperature during the middle third incubation
\item \code{MiddleThird.GrowthWeighted.temperature} Average temperature weighted by the actual growth during the middle third incubation
\item \code{MiddleThird.TimeWeighted.GrowthRateWeighted.temperature} Average temperature weighted by the growth rate during the middle third incubation
\item \code{TSP.TimeWeighted.sexratio} Sex ratio based on average temperature during the TSP
\item \code{TSP.GrowthWeighted.sexratio} Sex ratio based on average temperature weighted by the actual growth during the TSP
\item \code{TSP.TimeWeighted.GrowthRateWeighted.sexratio} Sex ratio based on average temperature weighted by the growth rate during the TSP
\item \code{TSP.TimeWeighted.STRNWeighted.sexratio} Sex ratio based on average temperature weighted by the thermal reaction norm of sexualization during the TSP
\item \code{TSP.GrowthWeighted.STRNWeighted.sexratio} Sex ratio based on average temperature weighted by the actual growth and thermal reaction norm of sexualization during the TSP
\item \code{TSP.TimeWeighted.GrowthRateWeighted.STRNWeighted.sexratio} Sex ratio based on average temperature weighted by the growth rate and the thermal reaction norm of sexualization during the TSP
\item \code{MiddleThird.TimeWeighted.sexratio} Sex ratio based on average temperature during the middle third incubation
\item \code{MiddleThird.GrowthWeighted.sexratio} Sex ratio based on average temperature weighted by actual growth during the middle third incubation
\item \code{MiddleThird.TimeWeighted.GrowthRateWeighted.sexratio} Sex ratio based on average temperature weighted by growth rate during the middle third incubation
\item \code{TimeWeighted.sexratio} Sex ratio based on average temperature during all incubation
\item \code{GrowthWeighted.sexratio} Sex ratio based on average temperature weighted by actual growth during all incubation
\item \code{TimeWeighted.GrowthRateWeighted.sexratio} Sex ratio based on average temperature weighted by growth rate during all incubation
}
If \code{out} is equal to \code{summary}, the return is a list with:
\itemize{
\item \code{summary} is a data.frame with statistics for each nest.
\item \code{dynamic.metric} object is a list composed of data.frames with the dynamics of growth for each nest. It showed only temperatures from original dataset.
\item \code{summary.dynamic.metric} is a data.frame with the following columns with the suffix .mean, .se or .quantile_x with x from the parameter probs.
}
If \code{out} is equal to \code{details}, the return is a list with:
\itemize{
\item The statistics for each replicate for each nest (one per element of the list)
}
If \code{out} is equal to \code{metric}, the return is a list with:
\itemize{
\item \code{dynamic.metric} object is a list composed of data.frames with the dynamics of growth for each nest
\item \code{indices.dynamic.metric} is a data.frame with the following columns.
}
The object \code{summary.dynamic.metric} or \code{indices.dynamic.metric} is a data.frame with the following columns:
\itemize{
\item \code{series} Name of the series
\item \code{metric.begin.tsp} Metric at the beginning of TSP
\item \code{metric.end.tsp} Metric at the end of TSP
\item \code{hatchling.metric.mean} Average expected size of hatchlings
\item \code{hatchling.metric.sd} standard deviation of expected size of hatchlings
\item \code{time.begin.tsp} Time at the beginning of TSP
\item \code{time.end.tsp} Time at the end of TSP
\item \code{time.begin.middlethird} Time at the beginning of the middle third incubation
\item \code{time.end.middlethird} Time at the end of the middle third incubation
\item \code{stop.at.hatchling.metric} Take the value of NA if stop.at.hatchling.metric was FALSE. TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
\item \code{stop.at.hatchling.metric} Take the value of NA if stop.at.hatchling.metric was FALSE. TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
\item \code{stop.at.hatchling.metric} Take the value of NA if stop.at.hatchling.metric was FALSE. TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
\item \code{stop.at.hatchling.metric} Take the value of NA if stop.at.hatchling.metric was FALSE. TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
\item \code{stop.at.hatchling.metric} Take the value of NA if stop.at.hatchling.metric was FALSE. TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
\item \code{stop.at.hatchling.metric} Take the value of NA if stop.at.hatchling.metric was FALSE. TRUE if at least one incubation series was longer than hatchling size and FALSE at contrary
}
If you indicate new set of temperatures, you must probably also indicate new hatchling.metric values.\cr
Note: four species have predefined embryo stages. embryo.stages parameter can take the values:\cr
\itemize{
\item \code{Caretta caretta.SCL}
\item \code{Chelonia mydas.SCL}
\item \code{Emys orbicularis.SCL}
\item \code{Emys orbicularis.mass}
\item \code{Podocnemis expansa.SCL}
\item \code{Lepidochelys olivacea.SCL}
\item \code{Generic.ProportionDevelopment}
}
But remember that mass is not the best proxy to describe the growth of an embryo because it can decrease if the substrate becomes dry.\cr
The progress bar is based on both replicates and timeseries progress. It necessitates the pbapply package.\cr
If replicate.CI is null or 0, only maximum likelihood is used and no confidence interval is calculated.\cr
If replicate.CI is 1, one random value for the parameters is used but no confidence interval is calculated.\cr
In other cases, replicate.CI random samples are used to estimate confidence interval.\cr
About parallel computing:\cr
Set options mc.cores ato tell what sort of parallel computing\cr
Example:\cr
options(mc.cores = detectCores())\cr
If mc.cores is not defined, it will used detectCores() by default.
}
\details{
Calculate statistics about nests
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p_SSM)
# Some basic calculations to show the advantage of parallel computing
system.time(summary.nests <- info.nests(x=resultNest_4p_SSM, out="summary", 
  embryo.stages="Caretta caretta.SCL", replicate.CI=0, parallel=FALSE))
system.time(summary.nests <- info.nests(x=resultNest_4p_SSM, out="summary", 
  embryo.stages="Caretta caretta.SCL", replicate.CI=0, parallel=TRUE))
system.time(summary.nests <- info.nests(x=resultNest_4p_SSM, out="summary", 
  embryo.stages="Caretta caretta.SCL", replicate.CI=0, parallel=TRUE, progressbar=TRUE))
system.time(summary.nests <- info.nests(x=resultNest_4p_SSM, out="likelihood", 
  embryo.stages="Caretta caretta.SCL", replicate.CI=0, parallel=TRUE, progressbar=FALSE))
  
# By default parallel computing is TRUE but progressbar is FALSE
# When out is "likelihood", it returns only the likelihood
# otherwise, it returns a list with 3 objects "summary", 
#        "dynamic.metric", and "summary.dynamic.metric".

summary.nests <- info.nests(resultNest_4p_SSM, out="summary", 
  embryo.stages="Caretta caretta.SCL", 
  replicate.CI=100, 
  resultmcmc=resultNest_mcmc_4p_SSM, 
  GTRN.CI="MCMC", 
  progressbar=TRUE)
  
summary.nests <- info.nests(resultNest_4p_SSM, 
  embryo.stages="Caretta caretta.SCL", 
  out="summary", replicate.CI=100, 
  GTRN.CI="Hessian", 
  progressbar=TRUE)
  
summary.nests <- info.nests(resultNest_4p_SSM, 
  series = 1, 
  embryo.stages="Caretta caretta.SCL", 
  out="summary", replicate.CI=100, 
  GTRN.CI="SE", 
  progressbar=TRUE)
  
# Example of use of embryo.stages and TSP.borders:
  summary.nests <- info.nests(resultNest_4p_SSM, out="summary", 
                            embryo.stages=c("10"=0.33, "11"=0.33, "12"=0.66, "13"=0.66), 
                            TSP.borders = c(10, 12), 
                            replicate.CI=100,
                            progressbar=TRUE)
                            
#########################################
# Sex ratio using Massey et al. method PM
#########################################

# Massey, M.D., Holt, S.M., Brooks, R.J., Rollinson, N., 2019. Measurement 
# and modelling of primary sex ratios for species with temperature-dependent 
# sex determination. J Exp Biol 222, 1-9.
  
CC_Mediterranean <- subset(DatabaseTSD, RMU=="Mediterranean" & 
Species=="Caretta caretta" & (!is.na(Sexed) & Sexed!=0))
tsdL <- with (CC_Mediterranean, tsd(males=Males, females=Females, 
                                    temperatures=Incubation.temperature, 
                                    equation="logistic", replicate.CI=NULL))
                                    
PM <- info.nests(x=resultNest_4p_SSM, 
  GTRN.CI="Hessian", tsd.CI="Hessian", 
  embryo.stages="Caretta caretta.SCL", replicate.CI=100, 
  out="summary", progressbar=TRUE, tsd=tsdL)
  

plot_errbar(x=PM$summary$TimeWeighted.temperature.mean, 
            y=PM$summary$TSP.PM.GrowthWeighted.mean, 
            y.minus=PM$summary$TSP.PM.GrowthWeighted.quantile_0.025, 
            y.plus=PM$summary$TSP.PM.GrowthWeighted.quantile_0.975, 
            xlab="CTE SCL growth", 
            ylab="PM Massey et al. 2016", xlim=c(26, 32), ylim=c(0, 1), las=1)

# Relationship between growth and growth rate

infoall.df <- info.nests(x=resultNest_4p_SSM, out="summary", 
  embryo.stages="Caretta caretta.SCL", 
  replicate.CI=100, 
  resultmcmc=resultNest_mcmc_4p_SSM, 
  GTRN.CI="MCMC", 
  progressbar=TRUE)
  
  layout(1)
plot(x=infoall.df$dynamic.metric[[1]][, "Time"], 
     y=infoall.df$dynamic.metric[[1]][, "Metric_50\%"], 
     type="l", las=1, bty="n", 
     xlab="Time in minute", ylab="Growth", ylim=c(0, 39), xlim=c(0, 100000))
lines(x=infoall.df$dynamic.metric[[1]][, "Time"], 
     y=infoall.df$dynamic.metric[[1]][, "Metric_2.5\%"], lty=2)
lines(x=infoall.df$dynamic.metric[[1]][, "Time"], 
     y=infoall.df$dynamic.metric[[1]][, "Metric_97.5\%"], lty=2)
}
}
\references{
\insertRef{9039}{embryogrowth}\cr
\insertRef{10871}{embryogrowth}\cr
\insertRef{8566}{embryogrowth}\cr
\insertRef{10620}{embryogrowth}\cr
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
