% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-portkey.R
\name{chat_portkey}
\alias{chat_portkey}
\alias{models_portkey}
\title{Chat with a model hosted on PortkeyAI}
\usage{
chat_portkey(
  system_prompt = NULL,
  base_url = "https://api.portkey.ai/v1",
  api_key = portkeyai_key(),
  virtual_key = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  echo = NULL
)

models_portkey(
  base_url = "https://api.portkey.ai/v1",
  api_key = portkeyai_key(),
  virtual_key = NULL
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{api_key}{API key to use for authentication.

You generally should not supply this directly, but instead set the \code{PORTKEY_API_KEY} environment variable.
The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.}

\item{virtual_key}{A virtual identifier storing LLM provider's API key. See
\href{https://portkey.ai/docs/product/ai-gateway/virtual-keys}{documentation}.}

\item{model}{The model to use for the chat (defaults to "gpt-4o").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.
Use \code{models_openai()} to see all options.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://portkey.ai/docs/product/ai-gateway/universal-api}{PortkeyAI}
provides an interface (AI Gateway) to connect through its Universal API to a
variety of LLMs providers with a single endpoint.
\subsection{Authentication}{

API keys together with configurations of LLM providers are
stored inside Portkey application.
}
}
\examples{
\dontrun{
chat <- chat_portkey(virtual_key = Sys.getenv("PORTKEY_VIRTUAL_KEY"))
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
