% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turns.R
\name{Turn}
\alias{Turn}
\title{A user or assistant turn}
\usage{
Turn(role, contents = list(), json = list(), tokens = c(0, 0))
}
\arguments{
\item{role}{Either "user", "assistant", or "system".}

\item{contents}{A list of \link{Content} objects.}

\item{json}{The serialized JSON corresponding to the underlying data of
the turns. Currently only provided for assistant.

This is useful if there's information returned by the provider that ellmer
doesn't otherwise expose.}

\item{tokens}{A numeric vector of length 2 representing the number of
input and output tokens (respectively) used in this turn. Currently
only recorded for assistant turns.}
}
\value{
An S7 \code{Turn} object
}
\description{
Every conversation with a chatbot consists of pairs of user and assistant
turns, corresponding to an HTTP request and response. These turns are
represented by the \code{Turn} object, which contains a list of \link{Content}s representing
the individual messages within the turn. These might be text, images, tool
requests (assistant only), or tool responses (user only).

Note that a call to \verb{$chat()} and related functions may result in multiple
user-assistant turn cycles. For example, if you have registered tools,
ellmer will automatically handle the tool calling loop, which may result in
any number of additional cycles. Learn more about tool calling in
\code{vignette("tool-calling")}.
}
\examples{
Turn(role = "user", contents = list(ContentText("Hello, world!")))
}
