% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_observation.R
\name{create_observation}
\alias{create_observation}
\title{Create the observation table}
\usage{
create_observation(
  L0_flat,
  observation_id,
  event_id = NULL,
  package_id,
  location_id,
  datetime,
  taxon_id,
  variable_name,
  value,
  unit = NULL
)
}
\arguments{
\item{L0_flat}{(tbl_df, tbl, data.frame) The fully joined source L0 dataset, in "flat" format (see details).}

\item{observation_id}{(character) Column in \code{L0_flat} containing the identifier assigned to each unique observation.}

\item{event_id}{(character) An optional column in \code{L0_flat} containing the identifier assigned to each unique sampling event.}

\item{package_id}{(character) Column in \code{L0_flat} containing the identifier of the derived L1 dataset.}

\item{location_id}{(character) Column in \code{L0_flat} containing the identifier assigned to each unique location at the observation level.}

\item{datetime}{(character) Column in \code{L0_flat} containing the date, and if applicable time, of the observation following the ISO-8601 standard format (e.g. YYYY-MM-DD hh:mm:ss).}

\item{taxon_id}{(character) Column in \code{L0_flat} containing the identifier assigned to each unique organism at the observation level.}

\item{variable_name}{(character) Column in \code{L0_flat} containing the names of variables measured.}

\item{value}{(character) Column in \code{L0_flat} containing the values of \code{variable_name}.}

\item{unit}{(character) An optional column in \code{L0_flat} containing the units of \code{variable_name}.}
}
\value{
(tbl_df, tbl, data.frame) The observation table.
}
\description{
Create the observation table
}
\details{
This function collects specified columns from \code{L0_flat} and returns distinct rows.

"flat" format refers to the fully joined source L0 dataset in "wide" form with the exception of the core observation variables, which are in "long" form (i.e. using the variable_name, value, unit columns of the observation table). This "flat" format is the "widest" an L1 ecocomDP dataset can be consistently spread due to the frequent occurrence of L0 source datasets with > 1 core observation variable.
}
\examples{
flat <- ants_L0_flat

observation <- create_observation(
  L0_flat = flat, 
  observation_id = "observation_id", 
  event_id = "event_id", 
  package_id = "package_id",
  location_id = "location_id", 
  datetime = "datetime", 
  taxon_id = "taxon_id", 
  variable_name = "variable_name",
  value = "value",
  unit = "unit")

observation

}
