/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.MixColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;

public class SubstanceMixTheme
extends SubstanceTheme {
    private SubstanceTheme[] originalThemes;

    public SubstanceMixTheme(SubstanceTheme ... originalThemes) {
        super(new MixColorScheme(SubstanceMixTheme.getSchemes(originalThemes)), SubstanceMixTheme.getName(originalThemes), SubstanceTheme.ThemeKind.MIXED);
        this.originalThemes = originalThemes;
    }

    private static ColorScheme[] getSchemes(SubstanceTheme ... themes) {
        ColorScheme[] result = new ColorScheme[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            result[i] = themes[i].getColorScheme();
        }
        return result;
    }

    private static String getName(SubstanceTheme ... themes) {
        StringBuffer idBuf = new StringBuffer();
        idBuf.append("Mixed ");
        String delim = "";
        for (SubstanceTheme theme : themes) {
            idBuf.append(delim);
            idBuf.append(theme.getDisplayName());
            delim = " & ";
        }
        return idBuf.toString();
    }

    public SubstanceTheme[] getOriginalThemes() {
        return this.originalThemes;
    }

    public SubstanceTheme tint(double tintFactor) {
        SubstanceTheme[] tinted = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            tinted[i] = this.originalThemes[i].tint(tintFactor);
        }
        return new SubstanceMixTheme(tinted);
    }

    public SubstanceTheme tone(double toneFactor) {
        SubstanceTheme[] toned = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            toned[i] = this.originalThemes[i].tone(toneFactor);
        }
        return new SubstanceMixTheme(toned);
    }

    public SubstanceTheme shade(double shadeFactor) {
        SubstanceTheme[] shaded = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            shaded[i] = this.originalThemes[i].shade(shadeFactor);
        }
        return new SubstanceMixTheme(shaded);
    }

    public SubstanceTheme saturate(double saturateFactor, boolean toSaturateEverything) {
        SubstanceTheme[] saturated = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            saturated[i] = this.originalThemes[i].saturate(saturateFactor, toSaturateEverything);
        }
        return new SubstanceMixTheme(saturated);
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        SubstanceTheme[] shaded = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            shaded[i] = this.originalThemes[i].hueShift(hueShiftFactor);
        }
        return new SubstanceMixTheme(shaded);
    }

    public SubstanceTheme invert() {
        SubstanceTheme[] inverted = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            inverted[i] = this.originalThemes[i].invert();
        }
        return new SubstanceMixTheme(inverted);
    }

    public SubstanceTheme negate() {
        SubstanceTheme[] negated = new SubstanceTheme[this.originalThemes.length];
        for (int i = 0; i < this.originalThemes.length; ++i) {
            negated[i] = this.originalThemes[i].negate();
        }
        return new SubstanceMixTheme(negated);
    }

    public SubstanceTheme getFirstTheme() {
        return this.getOriginalThemes()[0];
    }

    public SubstanceTheme getSecondTheme() {
        return this.getOriginalThemes()[this.getOriginalThemes().length - 1];
    }

    public SubstanceTheme getDefaultTheme() {
        return this.getOriginalThemes()[0].getDefaultTheme();
    }

    public SubstanceTheme getDisabledTheme() {
        return this.getOriginalThemes()[0].getDisabledTheme();
    }
}

