% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.R
\name{scale_fill_geopattern}
\alias{scale_fill_geopattern}
\title{Geologic pattern fill scale}
\usage{
scale_fill_geopattern(na.value = "grey50", ...)
}
\arguments{
\item{na.value}{The aesthetic value to use for missing (NA) values. May be
either a color or a \link[grid:patterns]{GridPattern} object (such as that
returned by \code{\link[=geo_pattern]{geo_pattern()}}).}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{scale_name}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The name of the scale
that should be used for error messages associated with this scale.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
  }}
}
\description{
Fill scale using the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php}{FGDC Digital Cartographic Standard for Geologic Map Symbolization}. Fill values
should correspond to specific pattern codes (see "Details").
}
\details{
For specific codes, see the "pattern numbers" in the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd/fgdc-geolsym-patternchart.pdf}{full pattern chart}
for valid \code{code} values. Daven Quinn has also assembled more accessible
documentation of the \href{https://davenquinn.com/projects/geologic-patterns/#pattern-reference}{map patterns/codes}
and \href{https://davenquinn.com/projects/geologic-patterns/#series-600}{lithology patterns/codes}.
\code{\link[rmacrostrat:def_lithologies]{rmacrostrat::def_lithologies()}} can also be used to look up pattern codes
for various lithologies (see the "fill" column). Note that codes associated
with color variants (e.g., "101-M") are supported but will result in the
default color variant instead (usually black and white, e.g., "101-K").

These patterns were originally processed and optimized by Daven Quinn and
are hosted on \href{https://github.com/davenquinn/geologic-patterns/}{GitHub}.
}
\section{Warning}{
 Pattern fills are not supported on all graphics devices.
Not all devices are under active development, and such devices are unlikely
to add support for new features (such as pattern fills). The new features
have only been implemented on a subset of graphics devices so far:
\code{\link[=cairo_pdf]{cairo_pdf()}}, \code{\link[=cairo_ps]{cairo_ps()}}, \code{\link[=x11]{x11(type="cairo")}},
\code{\link[=png]{png(type="cairo")}},
\code{\link[=jpeg]{jpeg(type="cairo")}},
\code{\link[=tiff]{tiff(type="cairo")}}, \code{\link[=svg]{svg()}}, and \code{\link[=pdf]{pdf()}}. Although
there is no support yet for \code{\link[=quartz]{quartz()}} or \code{\link[=windows]{windows()}}, almost all of the
graphics devices above will work on all major platforms. Further, the
\href{https://ragg.r-lib.org/}{ragg} and
\href{https://svglite.r-lib.org/index.html}{svglite} packages contain graphics
devices that support patterns. When using a graphics device where patterns
are not supported, closed shapes will be rendered with a transparent fill.
Note that, at least on Windows machines, the default device in RStudio and
in the knitr package is \code{\link[=png]{png()}}, which does not support patterns. In
RStudio, you can go to ‘Tools > Global Options > General > Graphics’ and
choose the ‘Cairo PNG’ device from the dropdown menu to display patterns.
Similar issues may arise when using RStudio on other operating systems.
}

\examples{
library(ggplot2)
vals <- c("101", "313", "603", "733")
ggplot(mpg, aes(factor(cyl), fill = vals[factor(cyl)])) +
  geom_bar() +
  scale_fill_geopattern(name = NULL)
}
\seealso{
FGDC patterns:
\code{\link{geo_pattern}()},
\code{\link{grid.pattern_geo}()}
}
\concept{patterns}
