% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_label.R
\name{var_label}
\alias{var_label}
\alias{var_label.defined}
\alias{var_label.dataset_df}
\alias{label_attribute}
\alias{var_label<-}
\alias{var_label<-.haven_labelled_defined}
\alias{var_label<-.dataset_df}
\title{Get / Set a variable label}
\usage{
\method{var_label}{defined}(x, ...)

\method{var_label}{dataset_df}(
  x,
  unlist = FALSE,
  null_action = c("keep", "fill", "skip", "na", "empty"),
  recurse = FALSE,
  ...
)

label_attribute(x)

var_label(x) <- value

\method{var_label}{haven_labelled_defined}(x) <- value

\method{var_label}{dataset_df}(x) <- value
}
\arguments{
\item{x}{a vector or a data.frame}

\item{...}{Further arguments passed to or used by methods.}

\item{unlist}{for data frames, return a named vector instead of a list}

\item{null_action}{for data frames, by default \code{NULL} will be returned for
columns with no variable label. Use "fill" to populate with the column name
instead, "skip" to remove such values from the returned list, "na" to
populate with \code{NA} or "empty" to populate with an empty string (\code{""}).}

\item{recurse}{if \code{TRUE}, will apply \code{var_label()} on packed columns
(see \code{\link[tidyr:pack]{tidyr::pack()}}) to return the variable labels of each sub-column;
otherwise, the label of the group of columns will be returned.}

\item{value}{a character string or \code{NULL} to remove the label
For data frames, with \code{var_labels()}, it could also be a named list or a
character vector of same length as the number of columns in \code{x}.}
}
\value{
\code{var_label()} returns the \code{label} attribute as a character
string. The \code{var_label<-} assignment method allows to add, remove, or
overwrite this attribute on a vector \code{x}. The assignment function returns
the \code{x} vector invisibly.
}
\description{
Add a human readable, easier to understand label as a metadata attribute to a
variable or vector than the programmatic vector object name, or column name
in the data frame.
}
\details{
See \code{\link[labelled:var_label]{labelled::var_label}} for details about
variable labels.
\cr
See \code{vignette("defined", package = "dataset")} to use comprehensively
with variable labels, namespaces, units of measures, and machine-independent
permanent variable identifiers.
}
\examples{
# Retrieve the label attribute:
var_label(orange_df$circumference)

# To (re)set the label attribute:
`var_label<-`(orange_df$circumference, "circumference (breast height)")

}
\seealso{
Other defined metadata methods and functions: 
\code{\link{defined}()},
\code{\link{var_namespace}()},
\code{\link{var_unit}()}
}
\concept{defined metadata methods and functions}
