% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{GetPredictionExplanationsMetadataFromJobId}
\alias{GetPredictionExplanationsMetadataFromJobId}
\title{Retrieve the prediction explanations metadata for a model using jobId}
\usage{
GetPredictionExplanationsMetadataFromJobId(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{integer. Unique integer identifier (return for example by
\code{RequestPredictionExplanations}).}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete.}
}
\value{
A named list which contains prediction explanation metadata. For more information see
  \code{GetPredictionExplanationsMetadata}.
}
\description{
Retrieve the prediction explanations metadata for a model using jobId
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModel(projectId, modelId)
  jobId <- RequestPredictionExplanations(model, datasetId)
  GetPredictionExplanationsMetadataFromJobId(projectId, jobId)
}
}
