% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owsa.R
\name{owsa}
\alias{owsa}
\title{One-way sensitivity analysis}
\usage{
owsa(
  sa_obj,
  params = NULL,
  ranges = NULL,
  nsamp = 100,
  outcome = c("eff", "cost", "nhb", "nmb", "nhb_loss", "nmb_loss"),
  wtp = NULL,
  strategies = NULL,
  poly.order = 2
)
}
\arguments{
\item{sa_obj}{sensitivity analysis object;
either a probabilistic sensitivity analysis (\code{\link{make_psa_obj}}) or
a deterministic sensitivity analysis object (\code{\link{run_owsa_det}})}

\item{params}{string vector with the name(s) of the parameter of interest. Defaults to all.}

\item{ranges}{a named list of the form c("param" = c(0, 1), ...)
that gives the ranges for the parameter of interest. If NULL,
parameter values from the middle 95% of the PSA samples are used. The number of samples
from this range is determined by \code{nsamp}.}

\item{nsamp}{number of samples to take from the ranges}

\item{outcome}{either effectiveness ("eff"), cost ("cost"), net health benefit ("nhb"),
net monetary benefit ("nmb"), or the opportunity loss in terms of NHB or
NMB ("nhb_loss" and "nmb_loss", respectively). "nmb_loss_voi" and "nhb_loss_voi" are only
used in internal function calls of metamodel within other VOI functions.}

\item{wtp}{if outcome is NHB or NMB (or the associated loss), must provide the willingness-to-pay threshold}

\item{strategies}{vector of strategies to consider. The default (NULL) is that all strategies are considered.}

\item{poly.order}{order of polynomial for the linear regression metamodel.
Default: 2}
}
\value{
An object of class \code{data.frame} and \code{owsa} with the results of the sensitivity analysis.
Can be visualized with \code{\link{plot.owsa}, \link{owsa_tornado}, and \link{owsa_opt_strat}}
}
\description{
When used on a PSA object, this function uses a polynomial regression metamodel to predict the
average outcome of a decision-analytic model as a function of a single input parameter.
When used on a DSA object, this function uses the DSA results directly to show how the selected outcome varies
as a function of the input parameter of interest. In the DSA context, this function is called
internally by \code{\link{run_owsa_det}} and should not be called by the user. In the PSA context,
the user must use this function to produce an \code{owsa} object.
}
