% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_solve.R
\name{calc_pdfs}
\alias{calc_pdfs}
\alias{calc_pdfs.ratcliff_dm}
\alias{calc_pdfs.drift_dm}
\title{Calculate the PDFs}
\usage{
calc_pdfs(drift_dm_obj, x_vec, t_vec, prms_solve)

\method{calc_pdfs}{ratcliff_dm}(drift_dm_obj, x_vec, t_vec, prms_solve)

\method{calc_pdfs}{drift_dm}(drift_dm_obj, x_vec, t_vec, prms_solve)
}
\arguments{
\item{drift_dm_obj}{a model of type \link{drift_dm}}

\item{x_vec}{numeric vector, the evidence space}

\item{t_vec}{numeric vector, the time space}

\item{prms_solve}{the discretization (see \link{prms_solve})}
}
\value{
a list of PDFs, with named entries for each condition. Each of this
entry contains a list of vectors, named "pdf_u" and "pdf_l"
}
\description{
This method takes the a model, the time and space vectors, and the
unpacked parameters for solving the PDF to derive the first passage
time across all conditions. It is a wrapper around the cpp implementations
and \link{add_residual}. Important: This function is used in the
depths of the package and the generic method is not exported.
}
\details{
calc_pdfs is a generic method which dispatches the function call (not
exported).

calc_pdfs.ratcliff_dm, is a specific method that checks for the presence of
the parameter \code{sd_muc}, and, if present, calls the calc_pdfs.drift_dm
function multiple times with different value for \code{muc} to approximate the
variable drift rate.

calc_pdfs.drift_dm is the function that will be called for all models.
It evaluates the different components of a model, and subsequently calls
the cpp implementations for the KFE or integral method. It also calls the
\link{add_residual} function to convolute the non-decision time to the
first passage time.

The numerical methods for deriving the PDFs are based on the code provided
by \insertCite{Richteretal.2023}{dRiftDM}.
}
\references{
\insertRef{Richteretal.2023}{dRiftDM}
}
\seealso{
\link{add_residual}
}
\keyword{internal}
