% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs.R
\name{get_skin_eye_hazard}
\alias{get_skin_eye_hazard}
\title{Get skin and eye hazard}
\usage{
get_skin_eye_hazard(
  DTXSID = NULL,
  API_key = NULL,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing skin and eye hazard data.
}
\description{
Get skin and eye hazard
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull skin and eye hazard data for BPA
bpa_skin_eye <- get_skin_eye_hazard_batch(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
