% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ct}
\alias{plot_ct}
\title{Plot subnetwork identified using the compute_crosstalk function}
\usage{
plot_ct(crosstalk_df, g, label_prop = 0.1, prop_keep = 0.4)
}
\arguments{
\item{crosstalk_df}{a dataframe containing the results of \code{compute_crosstalk}}

\item{g}{igraph network object.}

\item{label_prop}{Proportion of nodes to label - based on degree}

\item{prop_keep}{How many proteins do we want to keep in the visualization (as a proportion of total) -
subsets on top x proteins ranked by affinity score}
}
\value{
NULL, draws the identified subgraph to device\
}
\description{
Convenience function for plotting crosstalkers - if you want to make more
customized/dynamic figures, there are lots of packages that can facilitate that,
including: \code{visnetwork}, \code{ggraph}, and even the base R plotting library
}
\examples{
\dontrun{
ct_df <- compute_crosstalk(c("EGFR", "KRAS"))
g <- prep_biogrid()
plot_ct(ct_df, g = g)
}

}
