% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.climateSpace.R
\name{plot_climateSpace}
\alias{plot_climateSpace}
\title{Plot the studied climate space.}
\usage{
plot_climateSpace(
  x,
  climate = x$parameters$climate,
  save = FALSE,
  filename = "Climate_space.pdf",
  as.png = FALSE,
  png.res = 300,
  width = 7.48,
  height = min(9, 3.5 * length(climate)),
  y0 = 0.5,
  add_modern = FALSE,
  resol = 0.25
)
}
\arguments{
\item{x}{A \code{\link{crestObj}} generated by either the \code{\link{crest.calibrate}},
\code{\link{crest.reconstruct}} or \code{\link{crest}} functions.}

\item{climate}{Climate variables to be used to generate the plot. By default
all the variables are included.}

\item{save}{A boolean to indicate if the diagram should be saved as a pdf file.
Default is \code{FALSE}.}

\item{filename}{An absolute or relative path that indicates where the diagram
should be saved. Also used to specify the name of the file. Default:
the file is saved in the working directory under the name
\code{'Climate_space.pdf'}.}

\item{as.png}{A boolean to indicate if the output should be saved as a png.
Default is \code{FALSE} and the figure is saved as a pdf file.}

\item{png.res}{The resolution of the png file (default 300 pixels per inch).}

\item{width}{The width of the output file in inches (default 7.48in ~ 19cm).}

\item{height}{The height of the output file in inches (default 3in ~ 7.6cm
per variables).}

\item{y0}{The space to allocate to each title (default 0.3in ~ 0.76 cm.}

\item{add_modern}{A boolean to add the location and the modern climate values
to the plot (default \code{FALSE}).}

\item{resol}{For advanced users only: if higher resolution data are used to
estimate the \code{pdfs}, use this parameter to define the resolution
of the maps maps on the figures. (default is 0.25 degrees to match
with the default database).}
}
\value{
No return value, this function is used to plot.
}
\description{
Plot the studied climate space.
}
\examples{
\dontrun{
  data(crest_ex_pse)
  data(crest_ex_selection)
  reconstr <- crest.get_modern_data(
    pse = crest_ex_pse, taxaType = 0,
    climate = c("bio1", "bio12"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example"
  )
  reconstr <- crest.calibrate(reconstr,
    geoWeighting = TRUE, climateSpaceWeighting = TRUE,
    bin_width = c(2, 20), shape = c("normal", "lognormal")
  )
  plot_climateSpace(reconstr)
}

}
